/*
 * Decompiled with CFR 0.152.
 */
package common.swing;

import common.bixpp.Bixpp;
import common.bixpp.BixppParser;
import common.swing.BixPanel;
import common.swing.XMLFilter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;

public class BixFrame
extends JFrame {
    protected JMenuBar menuBar;
    protected JMenu fileMenu;
    protected JMenuItem openMItem;
    protected JMenuItem openUrlMItem;
    protected JMenuItem exitMItem;
    protected final JFileChooser fileChooser;
    protected Document document;
    protected BixPanel panel;
    protected Bixpp bixpp;
    protected BixppParser parser;
    protected JTextField uriField;

    public BixFrame(String title, Bixpp bixpp, BixPanel panel) {
        super(title);
        this.bixpp = bixpp;
        this.panel = panel;
        this.parser = new BixppParser(bixpp);
        this.fileChooser = new JFileChooser();
        this.fileChooser.setFileFilter(new XMLFilter());
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.openMItem = new JMenuItem("Open");
        this.openUrlMItem = new JMenuItem("OpenFromURL");
        this.exitMItem = new JMenuItem("Exit");
        this.fileMenu.setMnemonic('F');
        this.openMItem.setMnemonic('O');
        this.openUrlMItem.setMnemonic('U');
        this.exitMItem.setMnemonic('E');
        this.fileMenu.add(this.openMItem);
        this.fileMenu.add(this.openUrlMItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.exitMItem);
        this.menuBar.add(this.fileMenu);
        this.setJMenuBar(this.menuBar);
        this.openMItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                File file;
                int intRet = BixFrame.this.fileChooser.showOpenDialog(BixFrame.this);
                if (intRet == 0 && (file = new File(BixFrame.this.fileChooser.getSelectedFile().getAbsolutePath())).exists()) {
                    try {
                        BixFrame.this.parser.parse(file.toURI());
                        BixFrame.this.panel.parse();
                    }
                    catch (Exception ie) {
                        ie.printStackTrace();
                    }
                }
            }
        });
        this.openUrlMItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String str = JOptionPane.showInputDialog("URL\u306e\u5165\u529b");
                if (str != null) {
                    try {
                        BixFrame.this.parser.parse(new URI(str));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                    BixFrame.this.panel.parse();
                }
            }
        });
        this.exitMItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                System.exit(0);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public void setBixPanel(BixPanel panel) {
        this.panel = panel;
    }

    public void setBixpp(Bixpp b) {
        this.bixpp = b;
    }
}

