/*
 * Decompiled with CFR 0.152.
 */
package common.bixpp;

import common.bixpp.Bixpp;
import common.bixpp.DataItem;
import common.bixpp.StateList;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SaxParse
extends DefaultHandler {
    private String state;
    private Bixpp bixpp;
    private StateList stateList;

    public SaxParse(Bixpp bixpp) {
        this.bixpp = bixpp;
        this.stateList = new StateList();
    }

    public void startDocument() throws SAXException {
        this.state = "";
    }

    public void endDocument() throws SAXException {
        this.state = "";
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.stateList.add(qName);
        String lastState = this.stateList.getLastState();
        if (lastState.equals("DataItem")) {
            this.bixpp.createDataItem();
        } else if (lastState.equals("ImageItem")) {
            this.bixpp.createImageItem();
        } else if (lastState.equals("EventItem")) {
            this.bixpp.createEventItem();
        } else if (lastState.equals("Record")) {
            this.bixpp.createRecord();
        } else if (lastState.equals("Item")) {
            this.bixpp.getLastRecord().createItem();
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.stateList.size() > 0 && this.stateList.getLastState().equals(qName)) {
            this.stateList.remove(this.stateList.size() - 1);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String lastState = this.stateList.getLastState();
        String boobyState = this.stateList.getStateBack(1);
        String value = new String(ch, start, length);
        if (boobyState.equals("BIX-pp")) {
            if (lastState.equals("Version")) {
                this.bixpp.setVersion(value);
            } else if (lastState.equals("Create")) {
                this.bixpp.setCreate(value);
            } else if (lastState.equals("Update")) {
                this.bixpp.setUpdate(value);
            }
        } else if (boobyState.equals("Producer")) {
            if (lastState.equals("Name")) {
                this.bixpp.getProducer().setName(value);
            } else if (lastState.equals("PostAddress")) {
                this.bixpp.getProducer().setPostAddress(value);
            } else if (lastState.equals("Phone")) {
                this.bixpp.getProducer().setPhone(value);
            } else if (lastState.equals("FAX")) {
                this.bixpp.getProducer().setFax(value);
            } else if (lastState.equals("EmailAddress")) {
                this.bixpp.getProducer().setEmailAddress(value);
            }
        } else if (this.stateList.getStateBack(2).equals("Producer")) {
            if (lastState.equals("Name")) {
                this.bixpp.getProducer().getLink().setName(value);
            } else if (lastState.equals("URI")) {
                this.bixpp.getProducer().getLink().setUri(this.bixpp.getPathUri().resolve(value));
            }
        } else if (boobyState.equals("Farm")) {
            if (lastState.equals("Name")) {
                this.bixpp.getFarm().setName(value);
            } else if (lastState.equals("PostAddress")) {
                this.bixpp.getFarm().setPostAddress(value);
            } else if (lastState.equals("Phone")) {
                this.bixpp.getFarm().setPhone(value);
            } else if (lastState.equals("Area")) {
                this.bixpp.getFarm().setArea(value);
            }
        } else if (this.stateList.size() > 5 && this.stateList.getStateBack(3).equals("Farm")) {
            if (lastState.equals("Name")) {
                this.bixpp.getFarm().getLink().setName(value);
            } else if (lastState.equals("URI")) {
                this.bixpp.getFarm().getLink().setUri(this.bixpp.getPathUri().resolve(value));
            }
        } else if (boobyState.equals("Plant")) {
            if (lastState.equals("Name")) {
                this.bixpp.getCultivation().getPlant().setName(value);
            } else if (lastState.equals("Family")) {
                this.bixpp.getCultivation().getPlant().setFamily(value);
            } else if (lastState.equals("AcademicName")) {
                this.bixpp.getCultivation().getPlant().setAcademicName(value);
            } else if (lastState.equals("Cultivar")) {
                this.bixpp.getCultivation().getPlant().setCultivar(value);
            } else if (lastState.equals("Origin")) {
                this.bixpp.getCultivation().getPlant().setOrigin(value);
            }
        } else if (boobyState.equals("Cultivation")) {
            if (lastState.equals("NumberOfPlant")) {
                try {
                    this.bixpp.getCultivation().setNumberOfPlant(Integer.parseInt(value));
                }
                catch (NumberFormatException e) {}
            } else if (lastState.equals("PlantingType")) {
                this.bixpp.getCultivation().setPlantingType(value);
            } else if (lastState.equals("Start")) {
                this.bixpp.getCultivation().setStart(value);
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    this.bixpp.setStartDate(format.parse(value));
                }
                catch (ParseException e) {
                    this.bixpp.setStartDate(new Date());
                }
            }
        } else if (boobyState.equals("DataItem")) {
            if (lastState.equals("Index")) {
                try {
                    this.bixpp.getLastRecordItem().setIndex(Integer.parseInt(value));
                }
                catch (Exception e) {}
            } else if (lastState.equals("Name")) {
                this.bixpp.getLastRecordItem().setName(value);
            } else if (lastState.equals("Unit")) {
                ((DataItem)this.bixpp.getLastRecordItem()).setUnit(value);
            }
        } else if (boobyState.equals("ImageItem")) {
            if (lastState.equals("Index")) {
                try {
                    this.bixpp.getLastRecordItem().setIndex(Integer.parseInt(value));
                }
                catch (Exception e) {}
            } else if (lastState.equals("Name")) {
                this.bixpp.getLastRecordItem().setName(value);
            }
        } else if (boobyState.equals("EventItem")) {
            if (lastState.equals("Index")) {
                try {
                    this.bixpp.getLastRecordItem().setIndex(Integer.parseInt(value));
                }
                catch (Exception e) {}
            } else if (lastState.equals("Name")) {
                this.bixpp.getLastRecordItem().setName(value);
            }
        } else if (lastState.equals("Days")) {
            try {
                this.bixpp.getLastRecord().setDays(Integer.parseInt(value));
            }
            catch (Exception e) {}
        } else if (boobyState.equals("Item")) {
            if (lastState.equals("Index")) {
                try {
                    this.bixpp.getLastRecord().getLastItem().setIndex(Integer.parseInt(value));
                }
                catch (Exception e) {}
            } else if (lastState.equals("Value")) {
                try {
                    this.bixpp.getLastRecord().getLastItem().setValue(Double.parseDouble(value));
                }
                catch (Exception e) {}
            }
        } else if (this.stateList.size() > 5 && this.stateList.getState(this.stateList.size() - 4).equals("Item") && lastState.equals("URI")) {
            this.bixpp.getLastRecord().getLastItem().setUri(this.bixpp.getPathUri().resolve(value));
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void notationDecl(String name, String publicId, String systemId) {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }
}

