/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;

public class LogarithmicAxis
extends NumberAxis {
    public static final double LOG10_VALUE = Math.log(10.0);
    public static final double SMALL_LOG_VALUE = 1.0E-100;
    protected boolean allowNegativesFlag = false;
    protected boolean strictValuesFlag = true;
    protected final NumberFormat numberFormatterObj = NumberFormat.getInstance();
    protected boolean expTickLabelsFlag = false;
    protected boolean log10TickLabelsFlag = true;
    protected boolean smallLogFlag = false;

    public LogarithmicAxis(String string) {
        super(string);
        this.setupNumberFmtObj();
    }

    public void setAllowNegativesFlag(boolean bl) {
        this.allowNegativesFlag = bl;
    }

    public boolean getAllowNegativesFlag() {
        return this.allowNegativesFlag;
    }

    public void setStrictValuesFlag(boolean bl) {
        this.strictValuesFlag = bl;
    }

    public boolean getStrictValuesFlag() {
        return this.strictValuesFlag;
    }

    public void setExpTickLabelsFlag(boolean bl) {
        this.expTickLabelsFlag = bl;
        this.setupNumberFmtObj();
    }

    public boolean getExpTickLabelsFlag() {
        return this.expTickLabelsFlag;
    }

    public void setLog10TickLabelsFlag(boolean bl) {
        this.log10TickLabelsFlag = bl;
    }

    public boolean getLog10TickLabelsFlag() {
        return this.log10TickLabelsFlag;
    }

    public void setRange(Range range) {
        super.setRange(range);
        this.setupSmallLogFlag();
    }

    protected void setupSmallLogFlag() {
        double d = this.getRange().getLowerBound();
        this.smallLogFlag = !this.allowNegativesFlag && d < 10.0 && d > 0.0;
    }

    protected void setupNumberFmtObj() {
        if (this.numberFormatterObj instanceof DecimalFormat) {
            ((DecimalFormat)this.numberFormatterObj).applyPattern(this.expTickLabelsFlag ? "0E0" : "0.###");
        }
    }

    protected double switchedLog10(double d) {
        return this.smallLogFlag ? Math.log(d) / LOG10_VALUE : this.adjustedLog10(d);
    }

    public double adjustedLog10(double d) {
        boolean bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        if (d < 10.0) {
            d += (10.0 - d) / 10.0;
        }
        return bl ? -(Math.log(d) / LOG10_VALUE) : Math.log(d) / LOG10_VALUE;
    }

    protected double computeLogFloor(double d) {
        double d2;
        if (this.allowNegativesFlag) {
            if (d > 10.0) {
                d2 = Math.log(d) / LOG10_VALUE;
                d2 = Math.floor(d2);
                d2 = Math.pow(10.0, d2);
            } else if (d < -10.0) {
                d2 = Math.log(-d) / LOG10_VALUE;
                d2 = Math.floor(-d2);
                d2 = -Math.pow(10.0, -d2);
            } else {
                d2 = Math.floor(d);
            }
        } else if (d > 0.0) {
            d2 = Math.log(d) / LOG10_VALUE;
            d2 = Math.floor(d2);
            d2 = Math.pow(10.0, d2);
        } else {
            d2 = Math.floor(d);
        }
        return d2;
    }

    protected double computeLogCeil(double d) {
        double d2;
        if (this.allowNegativesFlag) {
            if (d > 10.0) {
                d2 = Math.log(d) / LOG10_VALUE;
                d2 = Math.ceil(d2);
                d2 = Math.pow(10.0, d2);
            } else if (d < -10.0) {
                d2 = Math.log(-d) / LOG10_VALUE;
                d2 = Math.ceil(-d2);
                d2 = -Math.pow(10.0, -d2);
            } else {
                d2 = Math.ceil(d);
            }
        } else if (d > 0.0) {
            d2 = Math.log(d) / LOG10_VALUE;
            d2 = Math.ceil(d2);
            d2 = Math.pow(10.0, d2);
        } else {
            d2 = Math.ceil(d);
        }
        return d2;
    }

    public void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            double d;
            double d2;
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.getDataRange(this);
            if (range == null) {
                range = new Range(0.0, 1.0);
                d2 = range.getLowerBound();
            } else {
                d2 = range.getLowerBound();
                if (this.strictValuesFlag && !this.allowNegativesFlag && d2 <= 0.0) {
                    throw new RuntimeException("Values less than or equal to zero not allowed with logarithmic axis");
                }
            }
            d2 = this.computeLogFloor(d2);
            if (!this.allowNegativesFlag && d2 >= 0.0 && d2 < 1.0E-100) {
                d2 = range.getLowerBound();
            }
            double d3 = range.getUpperBound();
            if (!this.allowNegativesFlag && d3 < 1.0 && d3 > 0.0 && d2 > 0.0) {
                d = Math.log(d3) / LOG10_VALUE;
                d = Math.ceil(-d + 0.001);
                d3 = (d = Math.pow(10.0, d)) > 0.0 ? Math.ceil(d3 * d) / d : Math.ceil(d3);
            } else {
                d3 = this.computeLogCeil(d3);
            }
            d = this.getAutoRangeMinimumSize();
            if (d3 - d2 < d && (d3 = (d3 + d2 + d) / 2.0) - (d2 = (d3 + d2 - d) / 2.0) < d) {
                double d4 = Math.abs(d3);
                double d5 = d4 > 1.0E-100 ? d4 / 100.0 : 0.01;
                d3 = (d3 + d2 + d5) / 2.0;
                d2 = (d3 + d2 - d5) / 2.0;
            }
            this.setRange(new Range(d2, d3), false, false);
            this.setupSmallLogFlag();
        }
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d2 = this.switchedLog10(range.getLowerBound());
        double d3 = this.switchedLog10(range.getUpperBound());
        double d4 = 0.0;
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d4 = rectangle2D.getMinX();
            d5 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d4 = rectangle2D.getMaxY();
            d5 = rectangle2D.getMinY();
        }
        d = this.switchedLog10(d);
        if (this.isInverted()) {
            return d5 - (d - d2) / (d3 - d2) * (d5 - d4);
        }
        return d4 + (d - d2) / (d3 - d2) * (d5 - d4);
    }

    public double translateJava2DtoValue(float f, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d = this.switchedLog10(range.getLowerBound());
        double d2 = this.switchedLog10(range.getUpperBound());
        double d3 = 0.0;
        double d4 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d3 = rectangle2D.getX();
            d4 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d3 = rectangle2D.getMaxY();
            d4 = rectangle2D.getMinY();
        }
        if (this.isInverted()) {
            return Math.pow(10.0, d2 - ((double)f - d3) / (d4 - d3) * (d2 - d));
        }
        return Math.pow(10.0, d + ((double)f - d3) / (d4 - d3) * (d2 - d));
    }

    public void refreshTicks(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.refreshTicksHorizontal(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.refreshTicksVertical(graphics2D, rectangle2D, rectangle2D2, rectangleEdge);
        }
    }

    public void refreshTicksHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        int n;
        this.getTicks().clear();
        Range range = this.getRange();
        double d = range.getLowerBound();
        if (this.smallLogFlag && d < 1.0E-100) {
            d = 1.0E-100;
        }
        double d2 = range.getUpperBound();
        int n2 = (int)Math.rint(this.switchedLog10(d));
        if (n2 == (n = (int)Math.rint(this.switchedLog10(d2))) && n2 > 0 && Math.pow(10.0, n2) > d) {
            --n2;
        }
        boolean bl = false;
        int n3 = n2;
        while (n3 <= n) {
            int n4 = 0;
            while (n4 < 10) {
                String string;
                double d3;
                if (this.smallLogFlag) {
                    d3 = Math.pow(10.0, n3) + Math.pow(10.0, n3) * (double)n4;
                    if (this.expTickLabelsFlag || n3 < 0 && d3 > 0.0 && d3 < 1.0) {
                        if (n4 == 0 || n3 > -4 && n4 < 2 || d3 >= d2) {
                            this.numberFormatterObj.setMaximumFractionDigits(-n3);
                            string = this.makeTickLabel(d3, true);
                        } else {
                            string = "";
                        }
                    } else {
                        string = n4 < 1 || n3 < 1 && n4 < 5 || n4 < 4 - n3 || d3 >= d2 ? this.makeTickLabel(d3) : "";
                    }
                } else {
                    if (bl) {
                        --n4;
                    }
                    double d4 = d3 = n3 >= 0 ? Math.pow(10.0, n3) + Math.pow(10.0, n3) * (double)n4 : -(Math.pow(10.0, -n3) - Math.pow(10.0, -n3 - 1) * (double)n4);
                    if (!bl) {
                        if (Math.abs(d3 - 1.0) < 1.0E-4 && d <= 0.0 && d2 >= 0.0) {
                            d3 = 0.0;
                            bl = true;
                        }
                    } else {
                        bl = false;
                    }
                    String string2 = string = this.expTickLabelsFlag && n4 < 2 || n4 < 1 || n3 < 1 && n4 < 5 || n4 < 4 - n3 || d3 >= d2 ? this.makeTickLabel(d3) : "";
                }
                if (d3 > d2) {
                    return;
                }
                if (d3 >= d - 1.0E-100) {
                    double d5 = this.translateValueToJava2D(d3, rectangle2D2, rectangleEdge);
                    Rectangle2D rectangle2D3 = this.getTickLabelFont().getStringBounds(string, graphics2D.getFontRenderContext());
                    float f = 0.0f;
                    float f2 = 0.0f;
                    Insets insets = this.getTickLabelInsets();
                    if (this.isVerticalTickLabels()) {
                        f = (float)(d5 + rectangle2D3.getHeight() / 2.0);
                        f2 = rectangleEdge == RectangleEdge.TOP ? (float)(rectangle2D2.getMinY() - (double)insets.bottom - rectangle2D3.getWidth()) : (float)(rectangle2D2.getMaxY() + (double)insets.top + rectangle2D3.getWidth());
                    } else {
                        f = (float)(d5 - rectangle2D3.getWidth() / 2.0);
                        f2 = rectangleEdge == RectangleEdge.TOP ? (float)(rectangle2D2.getMinY() - (double)insets.bottom) : (float)(rectangle2D2.getMaxY() + (double)insets.top + rectangle2D3.getHeight());
                    }
                    Tick tick = new Tick(new Double(d3), string, f, f2);
                    this.getTicks().add(tick);
                }
                ++n4;
            }
            ++n3;
        }
    }

    public void refreshTicksVertical(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        int n;
        this.getTicks().clear();
        double d = this.getRange().getLowerBound();
        if (this.smallLogFlag && d < 1.0E-100) {
            d = 1.0E-100;
        }
        double d2 = this.getRange().getUpperBound();
        int n2 = (int)Math.rint(this.switchedLog10(d));
        if (n2 == (n = (int)Math.rint(this.switchedLog10(d2))) && n2 > 0 && Math.pow(10.0, n2) > d) {
            --n2;
        }
        boolean bl = false;
        int n3 = n2;
        while (n3 <= n) {
            int n4 = 10;
            if (n3 == n) {
                n4 = 1;
            }
            int n5 = 0;
            while (n5 < n4) {
                String string;
                double d3;
                if (this.smallLogFlag) {
                    d3 = Math.pow(10.0, n3) + Math.pow(10.0, n3) * (double)n5;
                    if (n5 == 0) {
                        if (this.log10TickLabelsFlag) {
                            string = "10^" + n3;
                        } else if (this.expTickLabelsFlag) {
                            string = "1e" + n3;
                        } else if (n3 >= 0) {
                            string = Long.toString((long)Math.rint(d3));
                        } else {
                            this.numberFormatterObj.setMaximumFractionDigits(-n3);
                            string = this.numberFormatterObj.format(d3);
                        }
                    } else {
                        string = "";
                    }
                } else {
                    if (bl) {
                        --n5;
                    }
                    double d4 = d3 = n3 >= 0 ? Math.pow(10.0, n3) + Math.pow(10.0, n3) * (double)n5 : -(Math.pow(10.0, -n3) - Math.pow(10.0, -n3 - 1) * (double)n5);
                    if (n5 == 0) {
                        if (!bl) {
                            if (n3 > n2 && n3 < n && Math.abs(d3 - 1.0) < 1.0E-4) {
                                d3 = 0.0;
                                bl = true;
                                string = "0";
                            } else {
                                string = this.log10TickLabelsFlag ? (n3 < 0 ? "-" : "") + "10^" + Math.abs(n3) : (this.expTickLabelsFlag ? (n3 < 0 ? "-" : "") + "1e" + Math.abs(n3) : Long.toString((long)Math.rint(d3)));
                            }
                        } else {
                            string = "";
                            bl = false;
                        }
                    } else {
                        string = "";
                        bl = false;
                    }
                }
                if (d3 > d2) {
                    return;
                }
                if (d3 >= d - 1.0E-100) {
                    double d5 = this.translateValueToJava2D(d3, rectangle2D2, rectangleEdge);
                    Rectangle2D rectangle2D3 = this.getTickLabelFont().getStringBounds(string, graphics2D.getFontRenderContext());
                    float f = rectangleEdge == RectangleEdge.LEFT ? (float)(rectangle2D2.getX() - rectangle2D3.getWidth() - (double)this.getTickLabelInsets().right) : (float)(rectangle2D2.getMaxX() + (double)this.getTickLabelInsets().left);
                    float f2 = (float)(d5 + rectangle2D3.getHeight() / 3.0);
                    this.getTicks().add(new Tick(new Double(d3), string, f, f2));
                }
                ++n5;
            }
            ++n3;
        }
    }

    protected String makeTickLabel(double d, boolean bl) {
        if (this.expTickLabelsFlag || bl) {
            return this.numberFormatterObj.format(d).toLowerCase();
        }
        return this.getTickUnit().valueToString(d);
    }

    protected String makeTickLabel(double d) {
        return this.makeTickLabel(d, false);
    }
}

