/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.Marker;
import org.jfree.chart.MarkerLabelPosition;
import org.jfree.chart.annotations.XYDrawableAnnotation;
import org.jfree.chart.annotations.XYPointerAnnotation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.TimeSeriesToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.XYDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class MarkerDemo1
extends ApplicationFrame {
    static /* synthetic */ Class class$0;

    public MarkerDemo1(String title) {
        super(title);
        XYDataset data = this.createDataset();
        JFreeChart chart = this.createChart(data);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setVerticalZoom(true);
        chartPanel.setHorizontalZoom(true);
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(XYDataset data) {
        JFreeChart chart = ChartFactory.createScatterPlot("Marker Demo 1", "X", "Y", data, PlotOrientation.VERTICAL, true, true, false);
        chart.getLegend().setAnchor(2);
        XYPlot plot = chart.getXYPlot();
        plot.getRenderer().setToolTipGenerator(new TimeSeriesToolTipGenerator());
        DateAxis domainAxis = new DateAxis("Time");
        domainAxis.setUpperMargin(0.5);
        plot.setDomainAxis(domainAxis);
        ValueAxis rangeAxis = plot.getRangeAxis();
        rangeAxis.setUpperMargin(0.3);
        rangeAxis.setLowerMargin(0.5);
        Marker start = new Marker(200.0, Color.green);
        start.setLabel("Bid Start Price");
        start.setLabelPosition(MarkerLabelPosition.TOP_RIGHT);
        plot.addRangeMarker(start);
        Marker target = new Marker(175.0, Color.red);
        target.setLabel("Target Price");
        target.setLabelPosition(MarkerLabelPosition.TOP_RIGHT);
        plot.addRangeMarker(target);
        Hour hour = new Hour(2, new Day(22, 5, 2003));
        double millis = hour.getFirstMillisecond();
        Marker originalEnd = new Marker(millis, Color.orange);
        originalEnd.setLabel("Original Close (02:00)");
        plot.addDomainMarker(originalEnd);
        Minute min = new Minute(15, hour);
        millis = min.getFirstMillisecond();
        Marker currentEnd = new Marker(millis, Color.red);
        currentEnd.setLabel("Close Date (02:15)");
        currentEnd.setLabelPosition(MarkerLabelPosition.TOP_RIGHT);
        plot.addDomainMarker(currentEnd);
        Hour h = new Hour(2, new Day(22, 5, 2003));
        Minute m = new Minute(10, h);
        millis = m.getFirstMillisecond();
        CircleDrawer cd = new CircleDrawer(Color.red, new BasicStroke(1.0f), null);
        XYDrawableAnnotation bestBid = new XYDrawableAnnotation(millis, 163.0, 11.0, 11.0, cd);
        plot.addAnnotation(bestBid);
        XYPointerAnnotation pointer = new XYPointerAnnotation("Best Bid", millis, 163.0, 2.356194490192345);
        pointer.setBaseRadius(35.0);
        pointer.setTipRadius(10.0);
        pointer.setFont(new Font("SansSerif", 0, 9));
        pointer.setPaint(Color.blue);
        pointer.setTextAnchor(TextAnchor.HALF_ASCENT_RIGHT);
        plot.addAnnotation(pointer);
        return chart;
    }

    private XYDataset createDataset() {
        TimeSeriesCollection result = new TimeSeriesCollection();
        result.addSeries(this.createSupplier1Bids());
        result.addSeries(this.createSupplier2Bids());
        return result;
    }

    private TimeSeries createSupplier1Bids() {
        Hour hour = new Hour(1, new Day(22, 5, 2003));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Minute");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries series1 = new TimeSeries("Supplier 1", clazz);
        series1.add((RegularTimePeriod)new Minute(13, hour), 200.0);
        series1.add((RegularTimePeriod)new Minute(14, hour), 195.0);
        series1.add((RegularTimePeriod)new Minute(45, hour), 190.0);
        series1.add((RegularTimePeriod)new Minute(46, hour), 188.0);
        series1.add((RegularTimePeriod)new Minute(47, hour), 185.0);
        series1.add((RegularTimePeriod)new Minute(52, hour), 180.0);
        return series1;
    }

    private TimeSeries createSupplier2Bids() {
        Hour hour1 = new Hour(1, new Day(22, 5, 2003));
        Hour hour2 = (Hour)hour1.next();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jfree.data.time.Minute");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TimeSeries series2 = new TimeSeries("Supplier 2", clazz);
        series2.add((RegularTimePeriod)new Minute(25, hour1), 185.0);
        series2.add((RegularTimePeriod)new Minute(0, hour2), 175.0);
        series2.add((RegularTimePeriod)new Minute(5, hour2), 170.0);
        series2.add((RegularTimePeriod)new Minute(6, hour2), 168.0);
        series2.add((RegularTimePeriod)new Minute(9, hour2), 165.0);
        series2.add((RegularTimePeriod)new Minute(10, hour2), 163.0);
        return series2;
    }

    public static void main(String[] args) {
        MarkerDemo1 demo = new MarkerDemo1("Marker Demo 1");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen(demo);
        ((Component)demo).setVisible(true);
    }
}

