/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.chart.AbstractTitle;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.FontChooserPanel;
import org.jfree.ui.FontDisplayField;
import org.jfree.ui.PaintSample;

public class TitlePropertyEditPanel
extends JPanel
implements ActionListener {
    private JTextField titleField;
    private Font titleFont;
    private JTextField fontfield;
    private PaintSample titlePaint;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.ui.LocalizationBundle");

    public TitlePropertyEditPanel(AbstractTitle abstractTitle) {
        this.setLayout(new BorderLayout());
        this.titlePaint = new PaintSample(Color.black);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), localizationResources.getString("General")));
        JPanel jPanel2 = new JPanel(new LCBLayout(3));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JLabel jLabel = new JLabel(localizationResources.getString("Text"));
        this.titleField = new JTextField();
        jPanel2.add(jLabel);
        jPanel2.add(this.titleField);
        jPanel2.add(new JPanel());
        jPanel2.add(new JLabel(localizationResources.getString("Font")));
        this.fontfield = new FontDisplayField(this.titleFont);
        JButton jButton = new JButton(localizationResources.getString("Select..."));
        jButton.setActionCommand("SelectFont");
        jButton.addActionListener(this);
        jPanel2.add(this.fontfield);
        jPanel2.add(jButton);
        jPanel2.add(new JLabel(localizationResources.getString("Color")));
        jButton = new JButton(localizationResources.getString("Select..."));
        jButton.setActionCommand("SelectPaint");
        jButton.addActionListener(this);
        jPanel2.add(this.titlePaint);
        jPanel2.add(jButton);
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "North");
    }

    public String getTitle() {
        return this.titleField.getText();
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Paint getTitlePaint() {
        return this.titlePaint.getPaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("SelectFont")) {
            this.attemptFontSelection();
        } else if (string.equals("SelectPaint")) {
            this.attemptPaintSelection();
        }
    }

    public void attemptFontSelection() {
        FontChooserPanel fontChooserPanel = new FontChooserPanel(this.titleFont);
        int n = JOptionPane.showConfirmDialog(this, fontChooserPanel, localizationResources.getString("Font_Selection"), 2, -1);
        if (n == 0) {
            this.titleFont = fontChooserPanel.getSelectedFont();
            this.fontfield.setText(this.titleFont.getFontName() + " " + this.titleFont.getSize());
        }
    }

    public void attemptPaintSelection() {
        Color color = JColorChooser.showDialog(this, localizationResources.getString("Title_Color"), Color.blue);
        if (color != null) {
            this.titlePaint.setPaint(color);
        }
    }

    public void setTitleProperties(AbstractTitle abstractTitle) {
        if (abstractTitle instanceof AbstractTitle) {
            // empty if block
        }
    }
}

