/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.BoxAndWhiskerToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.Outlier;
import org.jfree.chart.renderer.OutlierList;
import org.jfree.chart.renderer.OutlierListCollection;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.data.XYDataset;
import org.jfree.data.statistics.BoxAndWhiskerXYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class XYBoxAndWhiskerRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private double boxWidth;
    private transient Paint paint;
    private Paint artifactPaint = Color.black;

    public XYBoxAndWhiskerRenderer() {
        this(-1.0);
    }

    public XYBoxAndWhiskerRenderer(double d) {
        this.boxWidth = d;
        this.paint = Color.green;
        this.setToolTipGenerator(new BoxAndWhiskerToolTipGenerator());
    }

    public double getBoxWidth() {
        return this.boxWidth;
    }

    public void setBoxWidth(double d) {
        if (d != this.boxWidth) {
            Double d2 = new Double(this.boxWidth);
            this.boxWidth = d;
            this.firePropertyChanged("BoxAndWhiskerRenderer.boxWidth", d2, new Double(d));
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        Paint paint2 = this.paint;
        this.paint = paint;
        this.firePropertyChanged("BoxAndWhiskerRenderer.paint", paint2, paint);
    }

    public Paint getArtifactPaint() {
        return this.artifactPaint;
    }

    public void setArtifactPaint(Paint paint) {
        this.artifactPaint = paint;
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        this.setPaint(this.getItemPaint(n, n2));
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(graphics2D, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairInfo, n3);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n, n2, crosshairInfo, n3);
        }
    }

    public void drawHorizontalItem(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        BoxAndWhiskerXYDataset boxAndWhiskerXYDataset = (BoxAndWhiskerXYDataset)xYDataset;
        ArrayList arrayList = new ArrayList();
        Number number = boxAndWhiskerXYDataset.getXValue(n, n2);
        Number number2 = boxAndWhiskerXYDataset.getMaxRegularValue(n, n2);
        Number number3 = boxAndWhiskerXYDataset.getMinRegularValue(n, n2);
        Number number4 = boxAndWhiskerXYDataset.getMedianValue(n, n2);
        Number number5 = boxAndWhiskerXYDataset.getMeanValue(n, n2);
        Number number6 = boxAndWhiskerXYDataset.getQ1Value(n, n2);
        Number number7 = boxAndWhiskerXYDataset.getQ3Value(n, n2);
        List list = boxAndWhiskerXYDataset.getOutliers(n, n2);
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
        double d3 = valueAxis2.translateValueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
        double d4 = valueAxis2.translateValueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge);
        double d5 = valueAxis2.translateValueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge);
        double d6 = valueAxis2.translateValueToJava2D(number6.doubleValue(), rectangle2D, rectangleEdge);
        double d7 = valueAxis2.translateValueToJava2D(number7.doubleValue(), rectangle2D, rectangleEdge);
        ArrayList arrayList2 = new ArrayList();
        double d8 = this.boxWidth;
        double d9 = this.boxWidth;
        if (this.boxWidth <= 0.0) {
            int n4 = boxAndWhiskerXYDataset.getItemCount(n);
            d8 = rectangle2D.getHeight() / (double)n4 * 4.5 / 7.0;
            if (d8 < 1.0) {
                d8 = 1.0;
            }
            if ((d9 = d8) < 3.0) {
                d9 = 3.0;
            }
        }
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        if (d2 > d6 && d2 > d7) {
            graphics2D.draw(new Line2D.Double(d2, d, Math.max(d6, d7), d));
        }
        if (d3 < d6 && d3 < d7) {
            graphics2D.draw(new Line2D.Double(d3, d, Math.min(d6, d7), d));
        }
        Rectangle2D.Double double_ = null;
        if (d6 < d7) {
            double_ = new Rectangle2D.Double(d6, d - d9 / 2.0, d7 - d6, d9);
        } else {
            double_ = new Rectangle2D.Double(d7, d - d9 / 2.0, d6 - d7, d9);
            if (this.paint != null) {
                graphics2D.setPaint(this.paint);
                graphics2D.fill(double_);
            }
            graphics2D.draw(double_);
        }
        if (entityCollection != null) {
            String string = null;
            if (this.getToolTipGenerator() != null) {
                string = this.getToolTipGenerator().generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, string, string2);
            entityCollection.addEntity(xYItemEntity);
        }
    }

    public void drawVerticalItem(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairInfo crosshairInfo, int n3) {
        Object object;
        Object object2;
        Object object3;
        Cloneable cloneable;
        Paint paint;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        BoxAndWhiskerXYDataset boxAndWhiskerXYDataset = (BoxAndWhiskerXYDataset)xYDataset;
        Number number = boxAndWhiskerXYDataset.getXValue(n, n2);
        Number number2 = boxAndWhiskerXYDataset.getMaxRegularValue(n, n2);
        Number number3 = boxAndWhiskerXYDataset.getMinRegularValue(n, n2);
        Number number4 = boxAndWhiskerXYDataset.getMedianValue(n, n2);
        Number number5 = boxAndWhiskerXYDataset.getMeanValue(n, n2);
        Number number6 = boxAndWhiskerXYDataset.getQ1Value(n, n2);
        Number number7 = boxAndWhiskerXYDataset.getQ3Value(n, n2);
        List list = boxAndWhiskerXYDataset.getOutliers(n, n2);
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
        double d3 = valueAxis2.translateValueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
        double d4 = valueAxis2.translateValueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge);
        double d5 = 0.0;
        if (number5 != null) {
            d5 = valueAxis2.translateValueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge);
        }
        double d6 = valueAxis2.translateValueToJava2D(number6.doubleValue(), rectangle2D, rectangleEdge);
        double d7 = valueAxis2.translateValueToJava2D(number7.doubleValue(), rectangle2D, rectangleEdge);
        double d8 = this.boxWidth;
        double d9 = this.boxWidth;
        double d10 = rectangle2D.getMaxX() - rectangle2D.getMinX();
        double d11 = 0.1;
        double d12 = d10 * d11;
        if (this.boxWidth <= 0.0) {
            int n4 = boxAndWhiskerXYDataset.getItemCount(n);
            d8 = d10 / (double)n4 * 4.5 / 7.0;
            d9 = d8 < 3.0 ? 3.0 : (d8 > d12 ? d12 : d8);
        }
        if ((paint = this.getPaint()) != null) {
            graphics2D.setPaint(paint);
        }
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        if (d2 < d6 && d2 < d7) {
            graphics2D.draw(new Line2D.Double(d, d2, d, Math.max(d6, d7)));
            graphics2D.draw(new Line2D.Double(d - d9 / 2.0, d2, d + d9 / 2.0, d2));
        }
        if (d3 > d6 && d3 > d7) {
            graphics2D.draw(new Line2D.Double(d, d3, d, Math.min(d6, d7)));
            graphics2D.draw(new Line2D.Double(d - d9 / 2.0, d3, d + d9 / 2.0, d3));
        }
        Rectangle2D.Double double_ = null;
        double_ = d6 > d7 ? new Rectangle2D.Double(d - d9 / 2.0, d7, d9, d6 - d7) : new Rectangle2D.Double(d - d9 / 2.0, d6, d9, d7 - d6);
        graphics2D.fill(double_);
        graphics2D.draw(double_);
        graphics2D.setPaint(this.artifactPaint);
        graphics2D.draw(new Line2D.Double(d - d9 / 2.0, d4, d + d9 / 2.0, d4));
        double d13 = 0.0;
        double d14 = d9 / 3.0;
        if (number5 != null) {
            d13 = d9 / 4.0;
            cloneable = new Ellipse2D.Double(d - d13, d5 - d13, d13 * 2.0, d13 * 2.0);
            graphics2D.fill((Shape)((Object)cloneable));
            graphics2D.draw((Shape)((Object)cloneable));
        }
        cloneable = new ArrayList();
        OutlierListCollection outlierListCollection = new OutlierListCollection();
        int n5 = 0;
        while (n5 < list.size()) {
            double d15;
            double d16 = ((Number)list.get(n5)).doubleValue();
            if (d16 > boxAndWhiskerXYDataset.getMaxOutlier(n, n2).doubleValue()) {
                outlierListCollection.setHighFarOut(true);
            } else if (d16 < boxAndWhiskerXYDataset.getMinOutlier(n, n2).doubleValue()) {
                outlierListCollection.setLowFarOut(true);
            } else if (d16 > boxAndWhiskerXYDataset.getMaxRegularValue(n, n2).doubleValue()) {
                d15 = valueAxis2.translateValueToJava2D(d16, rectangle2D, rectangleEdge);
                cloneable.add(new Outlier(d, d15, d14));
            } else if (d16 < boxAndWhiskerXYDataset.getMinRegularValue(n, n2).doubleValue()) {
                d15 = valueAxis2.translateValueToJava2D(d16, rectangle2D, rectangleEdge);
                cloneable.add(new Outlier(d, d15, d14));
            }
            Collections.sort(cloneable);
            ++n5;
        }
        Iterator iterator = cloneable.iterator();
        while (iterator.hasNext()) {
            Outlier outlier = (Outlier)iterator.next();
            outlierListCollection.add(outlier);
        }
        double d17 = valueAxis2.translateValueToJava2D(valueAxis2.getUpperBound(), rectangle2D, rectangleEdge) + d13;
        double d18 = valueAxis2.translateValueToJava2D(valueAxis2.getLowerBound(), rectangle2D, rectangleEdge) - d13;
        Iterator iterator2 = outlierListCollection.iterator();
        while (iterator2.hasNext()) {
            object3 = (OutlierList)iterator2.next();
            object2 = ((OutlierList)object3).getAveragedOutlier();
            object = ((Outlier)object2).getPoint();
            if (((OutlierList)object3).isMultiple()) {
                this.drawMultipleEllipse((Point2D)object, d9, d14, graphics2D);
                continue;
            }
            this.drawEllipse((Point2D)object, d14, graphics2D);
        }
        if (outlierListCollection.isHighFarOut()) {
            this.drawHighFarOut(d13, graphics2D, d, d17);
        }
        if (outlierListCollection.isLowFarOut()) {
            this.drawLowFarOut(d13, graphics2D, d, d18);
        }
        if (entityCollection != null) {
            object3 = null;
            if (this.getToolTipGenerator() != null) {
                object3 = this.getToolTipGenerator().generateToolTip(xYDataset, n, n2);
            }
            object2 = null;
            if (this.getURLGenerator() != null) {
                object2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            object = new XYItemEntity(double_, xYDataset, n, n2, (String)object3, (String)object2);
            entityCollection.addEntity((ChartEntity)object);
        }
    }

    private void drawEllipse(Point2D point2D, double d, Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() + d / 2.0, point2D.getY(), d, d);
        graphics2D.draw(double_);
    }

    private void drawMultipleEllipse(Point2D point2D, double d, double d2, Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() - d / 2.0 + d2, point2D.getY(), d2, d2);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(point2D.getX() + d / 2.0, point2D.getY(), d2, d2);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
    }

    private void drawHighFarOut(double d, Graphics2D graphics2D, double d2, double d3) {
        double d4 = d * 2.0;
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 + d4, d2 + d4, d3 + d4));
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 + d4, d2, d3));
        graphics2D.draw(new Line2D.Double(d2 + d4, d3 + d4, d2, d3));
    }

    private void drawLowFarOut(double d, Graphics2D graphics2D, double d2, double d3) {
        double d4 = d * 2.0;
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 - d4, d2 + d4, d3 - d4));
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 - d4, d2, d3));
        graphics2D.draw(new Line2D.Double(d2 + d4, d3 - d4, d2, d3));
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof XYBoxAndWhiskerRenderer) {
            XYBoxAndWhiskerRenderer xYBoxAndWhiskerRenderer = (XYBoxAndWhiskerRenderer)object;
            boolean bl = super.equals(object);
            bl = bl && this.boxWidth == xYBoxAndWhiskerRenderer.getBoxWidth();
            bl = bl && this.paint.equals(xYBoxAndWhiskerRenderer.getPaint());
            return bl;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

