/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.Icon;
import org.jfree.chart.Marker;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.AbstractCategoryItemRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.Range;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RefineryUtilities;

public class MinMaxCategoryRenderer
extends AbstractCategoryItemRenderer {
    private double shapeScale = 6.0;
    private boolean plotLines = false;
    private transient Paint groupPaint = Color.black;
    private transient Stroke groupStroke = new BasicStroke(1.0f);
    private transient Icon minIcon = this.getIcon((Shape)new Arc2D.Double(-4.0, -4.0, 8.0, 8.0, 0.0, 360.0, 0), null, Color.black);
    private transient Icon maxIcon = this.getIcon((Shape)new Arc2D.Double(-4.0, -4.0, 8.0, 8.0, 0.0, 360.0, 0), null, Color.black);
    private transient Icon objectIcon = this.getIcon((Shape)new Line2D.Double(-4.0, 0.0, 4.0, 0.0), false, true);
    private int lastCategory = -1;
    private double min;
    private double max;
    private Number minValue;
    private Number maxValue;

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            Object object;
            double d = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d2 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, categoryPlot.getRangeAxisEdge());
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.setStroke(this.getItemStroke(n, n2));
            Rectangle2D.Double double_ = null;
            double_ = new Rectangle2D.Double(d - 4.0, d2 - 4.0, 8.0, 8.0);
            this.objectIcon.paintIcon(null, graphics2D, (int)d, (int)d2);
            if (this.lastCategory == n2) {
                if (this.minValue.doubleValue() > number.doubleValue()) {
                    this.min = d2;
                    this.minValue = number;
                }
                if (this.maxValue.doubleValue() < number.doubleValue()) {
                    this.max = d2;
                    this.maxValue = number;
                }
                if (categoryDataset.getRowCount() - 1 == n) {
                    graphics2D.setPaint(this.groupPaint);
                    graphics2D.setStroke(this.groupStroke);
                    graphics2D.draw(new Line2D.Double(d, this.min, d, this.max));
                    this.minIcon.paintIcon(null, graphics2D, (int)d, (int)this.min);
                    this.maxIcon.paintIcon(null, graphics2D, (int)d, (int)this.max);
                }
            } else {
                this.lastCategory = n2;
                this.min = d2;
                this.max = d2;
                this.minValue = number;
                this.maxValue = number;
            }
            if (this.plotLines && n2 != 0 && (object = categoryDataset.getValue(n, n2 - 1)) != null) {
                double d3 = ((Number)object).doubleValue();
                double d4 = categoryAxis.getCategoryStart(n2 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
                double d5 = valueAxis.translateValueToJava2D(d3, rectangle2D, categoryPlot.getRangeAxisEdge());
                graphics2D.setPaint(this.getItemPaint(n, n2));
                graphics2D.setStroke(this.getItemStroke(n, n2));
                Line2D.Double double_2 = new Line2D.Double(d4, d5, d, d2);
                graphics2D.draw(double_2);
            }
            if (this.getInfo() != null && (object = this.getInfo().getOwner().getEntityCollection()) != null && double_ != null) {
                String string = null;
                CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
                if (categoryItemLabelGenerator != null) {
                    string = categoryItemLabelGenerator.generateToolTip(categoryDataset, n, n2);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, null, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
                object.addEntity(categoryItemEntity);
            }
        }
    }

    private void drawLabel(Graphics2D graphics2D, String string, double d, double d2, Font font, boolean bl, int n) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        float f = lineMetrics.getLeading();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        int n2 = n;
        if (bl) {
            float f2;
            float f3;
            if (n2 == 1) {
                f3 = (float)(d + d4 / 2.0 - (double)lineMetrics.getDescent());
                f2 = (float)(d2 - this.shapeScale);
            } else if (n2 == 2) {
                f3 = (float)(d + d4 / 2.0 - (double)lineMetrics.getDescent());
                f2 = (float)(d2 + this.shapeScale + d3);
            } else if (n2 == 3) {
                f3 = (float)(d - this.shapeScale / 2.0 - (double)f - (double)lineMetrics.getDescent());
                f2 = (float)(d2 + d3 / 2.0);
            } else {
                f3 = (float)(d + this.shapeScale / 2.0 + (double)f + (double)lineMetrics.getAscent());
                f2 = (float)(d2 + d3 / 2.0);
            }
            RefineryUtilities.drawRotatedString(string, graphics2D, f3, f2, -1.5707963267948966);
        } else {
            float f4;
            float f5;
            if (n2 == 1) {
                f5 = (float)(d - d3 / 2.0);
                f4 = (float)(d2 - this.shapeScale / 2.0 - (double)lineMetrics.getDescent() - (double)f);
            } else if (n2 == 2) {
                f5 = (float)(d - d3 / 2.0);
                f4 = (float)(d2 + this.shapeScale / 2.0 + (double)lineMetrics.getAscent() + (double)f);
            } else if (n2 == 3) {
                f5 = (float)(d - this.shapeScale - d3);
                f4 = (float)(d2 + d4 / 2.0 - (double)lineMetrics.getDescent());
            } else {
                f5 = (float)(d + this.shapeScale);
                f4 = (float)(d2 + d4 / 2.0 - (double)lineMetrics.getDescent());
            }
            graphics2D.drawString(string, f5, f4);
        }
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D, Shape shape) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D, categoryPlot.getRangeAxisEdge());
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        graphics2D.setPaint(marker.getOutlinePaint());
        graphics2D.draw(double_);
    }

    public void setDrawLines(boolean bl) {
        this.plotLines = bl;
    }

    public boolean isDrawLines() {
        return this.plotLines;
    }

    public void setGroupPaint(Paint paint) {
        this.groupPaint = paint;
    }

    public Paint getGroupPaint() {
        return this.groupPaint;
    }

    public void setGroupStroke(Stroke stroke) {
        this.groupStroke = stroke;
    }

    public Stroke getGroupStroke() {
        return this.groupStroke;
    }

    public void setObjectIcon(Icon icon) {
        this.objectIcon = icon;
    }

    public Icon getObjectIcon() {
        return this.objectIcon;
    }

    public void setMaxIcon(Icon icon) {
        this.maxIcon = icon;
    }

    public Icon getMaxIcone() {
        return this.maxIcon;
    }

    public void setMinIcon(Icon icon) {
        this.minIcon = icon;
    }

    public Icon getMinIcon() {
        return this.minIcon;
    }

    private Icon getIcon(Shape shape, final Paint paint, final Paint paint2) {
        final int n = shape.getBounds().width;
        final int n2 = shape.getBounds().height;
        final GeneralPath generalPath = new GeneralPath(shape);
        return new Icon(){

            public void paintIcon(Component component, Graphics graphics, int n3, int n22) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                generalPath.transform(AffineTransform.getTranslateInstance(n3, n22));
                if (paint != null) {
                    graphics2D.setPaint(paint);
                    graphics2D.fill(generalPath);
                }
                if (paint2 != null) {
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(generalPath);
                }
                generalPath.transform(AffineTransform.getTranslateInstance(-n3, -n22));
            }

            public int getIconWidth() {
                return n;
            }

            public int getIconHeight() {
                return n2;
            }
        };
    }

    private Icon getIcon(Shape shape, final boolean bl, final boolean bl2) {
        final int n = shape.getBounds().width;
        final int n2 = shape.getBounds().height;
        final GeneralPath generalPath = new GeneralPath(shape);
        return new Icon(){

            public void paintIcon(Component component, Graphics graphics, int n3, int n22) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                generalPath.transform(AffineTransform.getTranslateInstance(n3, n22));
                if (bl) {
                    graphics2D.fill(generalPath);
                }
                if (bl2) {
                    graphics2D.draw(generalPath);
                }
                generalPath.transform(AffineTransform.getTranslateInstance(-n3, -n22));
            }

            public int getIconWidth() {
                return n;
            }

            public int getIconHeight() {
                return n2;
            }
        };
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.groupStroke, objectOutputStream);
        SerialUtilities.writePaint(this.groupPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.groupStroke = SerialUtilities.readStroke(objectInputStream);
        this.groupPaint = SerialUtilities.readPaint(objectInputStream);
        this.minIcon = this.getIcon((Shape)new Arc2D.Double(-4.0, -4.0, 8.0, 8.0, 0.0, 360.0, 0), null, Color.black);
        this.maxIcon = this.getIcon((Shape)new Arc2D.Double(-4.0, -4.0, 8.0, 8.0, 0.0, 360.0, 0), null, Color.black);
        this.objectIcon = this.getIcon((Shape)new Line2D.Double(-4.0, 0.0, 4.0, 0.0), false, true);
    }
}

