/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.IntervalBarRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.ui.RectangleEdge;

public class GanttRenderer
extends IntervalBarRenderer {
    private Paint completePaint = Color.green;
    private Paint incompletePaint = Color.red;
    private double startPercent = 0.35;
    private double endPercent = 0.65;

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        if (categoryDataset instanceof GanttCategoryDataset) {
            GanttCategoryDataset ganttCategoryDataset = (GanttCategoryDataset)categoryDataset;
            this.drawTasks(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, ganttCategoryDataset, n, n2);
        } else {
            super.drawItem(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        }
    }

    protected void drawTasks(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttCategoryDataset ganttCategoryDataset, int n, int n2) {
        int n3 = ganttCategoryDataset.getSubIntervalCount(n, n2);
        if (n3 == 0) {
            this.drawTask(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, ganttCategoryDataset, n, n2);
        }
        int n4 = 0;
        while (n4 < n3) {
            EntityCollection entityCollection;
            double d;
            double d2;
            RectangleEdge rectangleEdge = categoryPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge2 = categoryPlot.getRangeAxisEdge();
            Number number = ganttCategoryDataset.getStartValue(n, n2, n4);
            if (number == null) {
                return;
            }
            double d3 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge2);
            Number number2 = ganttCategoryDataset.getEndValue(n, n2, n4);
            if (number2 == null) {
                return;
            }
            double d4 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge2);
            if (d4 < d3) {
                d2 = d4;
                d4 = d3;
                d3 = d2;
            }
            d2 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, rectangleEdge);
            int n5 = this.getRowCount();
            int n6 = this.getColumnCount();
            if (n5 > 1) {
                d = rectangle2D.getHeight() * this.getItemMargin() / (double)(n6 * (n5 - 1));
                d2 += (double)n * (this.getBarWidth() + d);
            } else {
                d2 += (double)n * this.getBarWidth();
            }
            d = Math.abs(d4 - d3);
            double d5 = this.getBarWidth();
            Rectangle2D.Double double_ = null;
            if (categoryPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                double_ = new Rectangle2D.Double(d3, d2, d, d5);
            } else if (categoryPlot.getOrientation() == PlotOrientation.VERTICAL) {
                double_ = new Rectangle2D.Double(d2, d3, d5, d);
            }
            Rectangle2D.Double double_2 = null;
            Rectangle2D.Double double_3 = null;
            Number number3 = ganttCategoryDataset.getPercentComplete(n, n2, n4);
            if (number3 != null) {
                double d6 = number3.doubleValue();
                if (categoryPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                    double_2 = new Rectangle2D.Double(d3, d2 + this.startPercent * d5, d * d6, d5 * (this.endPercent - this.startPercent));
                    double_3 = new Rectangle2D.Double(d3 + d * d6, d2 + this.startPercent * d5, d * (1.0 - d6), d5 * (this.endPercent - this.startPercent));
                } else if (categoryPlot.getOrientation() == PlotOrientation.VERTICAL) {
                    double_2 = new Rectangle2D.Double(d2 + this.startPercent * d5, d3 + d * (1.0 - d6), d5 * (this.endPercent - this.startPercent), d * d6);
                    double_3 = new Rectangle2D.Double(d2 + this.startPercent * d5, d3, d5 * (this.endPercent - this.startPercent), d * (1.0 - d6));
                }
            }
            Paint paint = this.getItemPaint(n, n2);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (double_2 != null) {
                graphics2D.setPaint(this.completePaint);
                graphics2D.fill(double_2);
            }
            if (double_3 != null) {
                graphics2D.setPaint(this.incompletePaint);
                graphics2D.fill(double_3);
            }
            if (this.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_);
            }
            if (this.getInfo() != null && (entityCollection = this.getInfo().getOwner().getEntityCollection()) != null) {
                String string = null;
                if (this.getItemLabelGenerator(n, n2) != null) {
                    string = this.getItemLabelGenerator(n, n2).generateToolTip(ganttCategoryDataset, n, n2);
                }
                String string2 = null;
                if (this.getItemURLGenerator(n, n2) != null) {
                    string2 = this.getItemURLGenerator(n, n2).generateURL(ganttCategoryDataset, n, n2);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, ganttCategoryDataset, n, ganttCategoryDataset.getColumnKey(n2), n2);
                entityCollection.addEntity(categoryItemEntity);
            }
            ++n4;
        }
    }

    protected void drawTask(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttCategoryDataset ganttCategoryDataset, int n, int n2) {
        Object object;
        Object object2;
        double d;
        double d2;
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        RectangleEdge rectangleEdge = categoryPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = categoryPlot.getRangeAxisEdge();
        Number number = ganttCategoryDataset.getEndValue(n, n2);
        if (number == null) {
            return;
        }
        double d3 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge2);
        Number number2 = ganttCategoryDataset.getStartValue(n, n2);
        if (number2 == null) {
            return;
        }
        double d4 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge2);
        if (d4 < d3) {
            d2 = d4;
            d4 = d3;
            d3 = d2;
            Number number3 = number2;
            number2 = number;
            number = number3;
        }
        d2 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, rectangleEdge);
        double d5 = this.getBarWidth();
        double d6 = Math.abs(d4 - d3);
        Rectangle2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            if (n3 > 1) {
                d = rectangle2D.getHeight() * this.getItemMargin() / (double)(n4 * (n3 - 1));
                d2 += (double)n * (this.getBarWidth() + d);
            } else {
                d2 += (double)n * this.getBarWidth();
            }
            double_ = new Rectangle2D.Double(d3, d2, d6, d5);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            if (n3 > 1) {
                d = rectangle2D.getWidth() * this.getItemMargin() / (double)(n4 * (n3 - 1));
                d2 += (double)n * (this.getBarWidth() + d);
            } else {
                d2 += (double)n * this.getBarWidth();
            }
            double_ = new Rectangle2D.Double(d2, d4, d5, d6);
        }
        Rectangle2D.Double double_2 = null;
        Rectangle2D.Double double_3 = null;
        Number number4 = ganttCategoryDataset.getPercentComplete(n, n2);
        if (number4 != null) {
            double d7 = number4.doubleValue();
            if (categoryPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                double_2 = new Rectangle2D.Double(d3, d2 + this.startPercent * d5, d6 * d7, d5 * (this.endPercent - this.startPercent));
                double_3 = new Rectangle2D.Double(d3 + d6 * d7, d2 + this.startPercent * d5, d6 * (1.0 - d7), d5 * (this.endPercent - this.startPercent));
            } else if (categoryPlot.getOrientation() == PlotOrientation.VERTICAL) {
                double_2 = new Rectangle2D.Double(d2 + this.startPercent * d5, d4 + d6 * (1.0 - d7), d5 * (this.endPercent - this.startPercent), d6 * d7);
                double_3 = new Rectangle2D.Double(d2 + this.startPercent * d5, d4, d5 * (this.endPercent - this.startPercent), d6 * (1.0 - d7));
            }
        }
        Paint paint = this.getItemPaint(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (double_2 != null) {
            graphics2D.setPaint(this.completePaint);
            graphics2D.fill(double_2);
        }
        if (double_3 != null) {
            graphics2D.setPaint(this.incompletePaint);
            graphics2D.fill(double_3);
        }
        if (this.getBarWidth() > 3.0) {
            object2 = this.getItemOutlineStroke(n, n2);
            object = this.getItemOutlinePaint(n, n2);
            if (object2 != null && object != null) {
                graphics2D.setStroke((Stroke)object2);
                graphics2D.setPaint((Paint)object);
                graphics2D.draw(double_);
            }
        }
        if ((object2 = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, ganttCategoryDataset, n, n2, categoryPlot, (CategoryItemLabelGenerator)object2, double_, false);
        }
        if (this.getInfo() != null && (object = this.getInfo().getOwner().getEntityCollection()) != null) {
            String string = null;
            if (object2 != null) {
                string = object2.generateToolTip(ganttCategoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(ganttCategoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, ganttCategoryDataset, n, ganttCategoryDataset.getColumnKey(n2), n2);
            object.addEntity(categoryItemEntity);
        }
    }
}

