/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.data.Range;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtils;
import org.jfree.util.PublicCloneable;

public abstract class ValueAxis
extends Axis
implements Cloneable,
PublicCloneable,
Serializable {
    public static final Range DEFAULT_RANGE = new Range(0.0, 1.0);
    public static final boolean DEFAULT_AUTO_RANGE = true;
    public static final boolean DEFAULT_INVERTED = false;
    public static final double DEFAULT_AUTO_RANGE_MINIMUM_SIZE = 4.9E-323;
    public static final double DEFAULT_LOWER_MARGIN = 0.05;
    public static final double DEFAULT_UPPER_MARGIN = 0.05;
    public static final double DEFAULT_LOWER_BOUND = 0.0;
    public static final double DEFAULT_UPPER_BOUND = 1.0;
    public static final boolean DEFAULT_AUTO_TICK_UNIT_SELECTION = true;
    public static final int MAXIMUM_TICK_COUNT = 500;
    public static Stroke DEFAULT_AXIS_LINE_STROKE = new BasicStroke(1.0f);
    public static final Color DEFAULT_AXIS_LINE_PAINT = Color.gray;
    private boolean axisLineVisible = true;
    private boolean positiveArrowVisible = false;
    private boolean negativeArrowVisible = false;
    private transient Shape upArrow;
    private transient Shape downArrow;
    private transient Shape leftArrow;
    private transient Shape rightArrow;
    private transient Paint axisLinePaint = DEFAULT_AXIS_LINE_PAINT;
    private transient Stroke axisLineStroke = new BasicStroke(1.0f);
    private boolean inverted = false;
    private Range range;
    private boolean autoRange = true;
    private double autoRangeMinimumSize = 4.9E-323;
    private double upperMargin = 0.05;
    private double lowerMargin = 0.05;
    private double fixedAutoRange = 0.0;
    private boolean autoTickUnitSelection = true;
    private TickUnitSource standardTickUnits;
    private int autoTickIndex;
    protected double reservedForTickLabels;
    protected double reservedForAxisLabel;
    private boolean verticalTickLabels;

    protected ValueAxis(String string, TickUnitSource tickUnitSource) {
        super(string);
        this.axisLinePaint = Color.gray;
        this.axisLineStroke = DEFAULT_AXIS_LINE_STROKE;
        this.range = DEFAULT_RANGE;
        this.standardTickUnits = tickUnitSource;
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(-2, 2);
        polygon.addPoint(2, 2);
        this.upArrow = polygon;
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(0, 0);
        polygon2.addPoint(-2, -2);
        polygon2.addPoint(2, -2);
        this.downArrow = polygon2;
        Polygon polygon3 = new Polygon();
        polygon3.addPoint(0, 0);
        polygon3.addPoint(-2, -2);
        polygon3.addPoint(-2, 2);
        this.rightArrow = polygon3;
        Polygon polygon4 = new Polygon();
        polygon4.addPoint(0, 0);
        polygon4.addPoint(2, -2);
        polygon4.addPoint(2, 2);
        this.leftArrow = polygon4;
        this.verticalTickLabels = false;
    }

    public boolean isVerticalTickLabels() {
        return this.verticalTickLabels;
    }

    public void setVerticalTickLabels(boolean bl) {
        if (this.verticalTickLabels != bl) {
            this.verticalTickLabels = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isAxisLineVisible() {
        return this.axisLineVisible;
    }

    public void setAxisLineVisible(boolean bl) {
        this.axisLineVisible = bl;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isPositiveArrowVisible() {
        return this.positiveArrowVisible;
    }

    public void setPositiveArrowVisible(boolean bl) {
        this.positiveArrowVisible = bl;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isNegativeArrowVisible() {
        return this.negativeArrowVisible;
    }

    public void setNegativeArrowVisible(boolean bl) {
        this.negativeArrowVisible = bl;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Paint getAxisLinePaint() {
        return this.axisLinePaint;
    }

    public void setAxisLinePaint(Paint paint) {
        this.axisLinePaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Stroke getAxisLineStroke() {
        return this.axisLineStroke;
    }

    public void setAxisLineStroke(Stroke stroke) {
        this.axisLineStroke = stroke;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    protected void drawAxisLine(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Shape shape;
        AffineTransform affineTransform;
        Shape shape2;
        double d2;
        double d3;
        Line2D.Double double_ = null;
        if (rectangleEdge == RectangleEdge.TOP) {
            double_ = new Line2D.Double(rectangle2D.getX(), d, rectangle2D.getMaxX(), d);
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            double_ = new Line2D.Double(rectangle2D.getX(), d, rectangle2D.getMaxX(), d);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            double_ = new Line2D.Double(d, rectangle2D.getY(), d, rectangle2D.getMaxY());
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            double_ = new Line2D.Double(d, rectangle2D.getY(), d, rectangle2D.getMaxY());
        }
        graphics2D.setPaint(this.axisLinePaint);
        graphics2D.draw(double_);
        if (this.positiveArrowVisible) {
            d3 = 0.0;
            d2 = 0.0;
            shape2 = null;
            if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
                d3 = rectangle2D.getMaxX();
                d2 = d;
                shape2 = this.rightArrow;
            } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
                d3 = d;
                d2 = rectangle2D.getMinY();
                shape2 = this.upArrow;
            }
            affineTransform = new AffineTransform();
            affineTransform.setToTranslation(d3, d2);
            shape = affineTransform.createTransformedShape(shape2);
            graphics2D.fill(shape);
            graphics2D.draw(shape);
        }
        if (this.negativeArrowVisible) {
            d3 = 0.0;
            d2 = 0.0;
            shape2 = null;
            if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
                d3 = rectangle2D.getMinX();
                d2 = d;
                shape2 = this.leftArrow;
            } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
                d3 = d;
                d2 = rectangle2D.getMaxY();
                shape2 = this.downArrow;
            }
            affineTransform = new AffineTransform();
            affineTransform.setToTranslation(d3, d2);
            shape = affineTransform.createTransformedShape(shape2);
            graphics2D.fill(shape);
            graphics2D.draw(shape);
        }
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean bl) {
        if (this.inverted != bl) {
            this.inverted = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public void setAutoRange(boolean bl) {
        this.setAutoRange(bl, true);
    }

    protected void setAutoRange(boolean bl, boolean bl2) {
        if (this.autoRange != bl) {
            this.autoRange = bl;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            if (bl2) {
                this.notifyListeners(new AxisChangeEvent(this));
            }
        }
    }

    public double getAutoRangeMinimumSize() {
        return this.autoRangeMinimumSize;
    }

    public void setAutoRangeMinimumSize(double d) {
        this.setAutoRangeMinimumSize(d, true);
    }

    public void setAutoRangeMinimumSize(double d, boolean bl) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("NumberAxis.setAutoRangeMinimumSize(double): must be > 0.0.");
        }
        if (this.autoRangeMinimumSize != d) {
            this.autoRangeMinimumSize = d;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            if (bl) {
                this.notifyListeners(new AxisChangeEvent(this));
            }
        }
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double d) {
        this.upperMargin = d;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double d) {
        this.lowerMargin = d;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getFixedAutoRange() {
        return this.fixedAutoRange;
    }

    public void setFixedAutoRange(double d) {
        this.fixedAutoRange = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getMinimumAxisValue() {
        return this.getLowerBound();
    }

    public double getLowerBound() {
        return this.range.getLowerBound();
    }

    public void setMinimumAxisValue(double d) {
        this.setLowerBound(d);
    }

    public void setLowerBound(double d) {
        if (this.range.getUpperBound() > d) {
            this.setRange(new Range(d, this.range.getUpperBound()));
        } else {
            this.setRange(new Range(d, d + 1.0));
        }
    }

    public double getMaximumAxisValue() {
        return this.getUpperBound();
    }

    public double getUpperBound() {
        return this.range.getUpperBound();
    }

    public void setMaximumAxisValue(double d) {
        this.setUpperBound(d);
    }

    public void setUpperBound(double d) {
        if (this.range.getLowerBound() < d) {
            this.setRange(new Range(this.range.getLowerBound(), d));
        } else {
            this.setRange(d - 1.0, d);
        }
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range, boolean bl, boolean bl2) {
        if (range == null) {
            throw new IllegalArgumentException("ValueAxis.setRange(...): null not permitted.");
        }
        if (bl) {
            this.autoRange = false;
        }
        this.range = range;
        if (bl2) {
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void setRange(Range range) {
        this.setRange(range, true, true);
    }

    public void setRange(double d, double d2) {
        this.setRange(new Range(d, d2));
    }

    public void setRangeAboutValue(double d, double d2) {
        this.setRange(new Range(d - d2 / 2.0, d + d2 / 2.0));
    }

    public boolean isAutoTickUnitSelection() {
        return this.autoTickUnitSelection;
    }

    public void setAutoTickUnitSelection(boolean bl) {
        this.setAutoTickUnitSelection(bl, true);
    }

    public void setAutoTickUnitSelection(boolean bl, boolean bl2) {
        if (this.autoTickUnitSelection != bl) {
            this.autoTickUnitSelection = bl;
            if (bl2) {
                this.notifyListeners(new AxisChangeEvent(this));
            }
        }
    }

    public TickUnitSource getStandardTickUnits() {
        return this.standardTickUnits;
    }

    public void setStandardTickUnits(TickUnitSource tickUnitSource) {
        this.standardTickUnits = tickUnitSource;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public abstract double translateValueToJava2D(double var1, Rectangle2D var3, RectangleEdge var4);

    public abstract double translateJava2DtoValue(float var1, Rectangle2D var2, RectangleEdge var3);

    protected abstract void autoAdjustRange();

    public void centerRange(double d) {
        double d2 = this.range.getCentralValue();
        Range range = new Range(this.range.getLowerBound() + d - d2, this.range.getUpperBound() + d - d2);
        this.setRange(range);
    }

    public void resizeRange(double d) {
        this.resizeRange(d, this.range.getCentralValue());
    }

    public void resizeRange(double d, double d2) {
        if (d > 0.0) {
            double d3 = this.range.getLength() * d / 2.0;
            Range range = new Range(d2 - d3, d2 + d3);
            this.setRange(range);
        } else {
            this.setAutoRange(true);
        }
    }

    public void zoomRange(double d, double d2) {
        double d3 = this.range.getLowerBound();
        double d4 = this.range.getLength();
        Range range = null;
        range = this.isInverted() ? new Range(d3 + d4 * (1.0 - d2), d3 + d4 * (1.0 - d)) : new Range(d3 + d4 * d, d3 + d4 * d2);
        this.setRange(range);
    }

    protected int getAutoTickIndex() {
        return this.autoTickIndex;
    }

    protected void setAutoTickIndex(int n) {
        this.autoTickIndex = n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof ValueAxis) {
            ValueAxis valueAxis = (ValueAxis)object;
            if (super.equals(object)) {
                boolean bl = this.axisLineVisible == valueAxis.axisLineVisible;
                boolean bl2 = this.positiveArrowVisible == valueAxis.positiveArrowVisible;
                boolean bl3 = this.negativeArrowVisible == valueAxis.negativeArrowVisible;
                boolean bl4 = this.axisLinePaint.equals(valueAxis.axisLinePaint);
                boolean bl5 = this.axisLineStroke.equals(valueAxis.axisLineStroke);
                boolean bl6 = this.inverted == valueAxis.inverted;
                boolean bl7 = ObjectUtils.equal(this.range, valueAxis.range);
                boolean bl8 = this.autoRange == valueAxis.autoRange;
                boolean bl9 = Math.abs(this.autoRangeMinimumSize - valueAxis.autoRangeMinimumSize) < 1.0E-6;
                boolean bl10 = Math.abs(this.upperMargin - valueAxis.upperMargin) < 1.0E-6;
                boolean bl11 = Math.abs(this.lowerMargin - valueAxis.lowerMargin) < 1.0E-6;
                boolean bl12 = Math.abs(this.fixedAutoRange - valueAxis.fixedAutoRange) < 1.0E-6;
                boolean bl13 = this.autoTickUnitSelection == valueAxis.autoTickUnitSelection;
                boolean bl14 = ObjectUtils.equal(this.standardTickUnits, valueAxis.standardTickUnits);
                boolean bl15 = this.verticalTickLabels == valueAxis.verticalTickLabels;
                return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11 && bl12 && bl13 && bl14 && bl15;
            }
            return false;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        ValueAxis valueAxis = (ValueAxis)super.clone();
        return valueAxis;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.axisLinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.axisLineStroke, objectOutputStream);
        SerialUtilities.writeShape(this.upArrow, objectOutputStream);
        SerialUtilities.writeShape(this.downArrow, objectOutputStream);
        SerialUtilities.writeShape(this.leftArrow, objectOutputStream);
        SerialUtilities.writeShape(this.rightArrow, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.axisLinePaint = SerialUtilities.readPaint(objectInputStream);
        this.axisLineStroke = SerialUtilities.readStroke(objectInputStream);
        this.upArrow = SerialUtilities.readShape(objectInputStream);
        this.downArrow = SerialUtilities.readShape(objectInputStream);
        this.leftArrow = SerialUtilities.readShape(objectInputStream);
        this.rightArrow = SerialUtilities.readShape(objectInputStream);
    }
}

