/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.util.Iterator;
import org.jfree.chart.DrawableLegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.LegendItemLayout;

public class StandardLegendItemLayout
implements LegendItemLayout {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private int orientation;
    private double dimension;

    public StandardLegendItemLayout(int n, double d) {
        this.orientation = n;
        this.dimension = d;
    }

    public void layoutLegendItems(LegendItemCollection legendItemCollection) {
        if (this.orientation == 1) {
            this.doHorizontalLayout(legendItemCollection);
        } else if (this.orientation == 0) {
            this.doVerticalLayout(legendItemCollection);
        }
    }

    private void doHorizontalLayout(LegendItemCollection legendItemCollection) {
        Iterator iterator = legendItemCollection.iterator();
        boolean bl = true;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        while (iterator.hasNext()) {
            DrawableLegendItem drawableLegendItem = (DrawableLegendItem)iterator.next();
            if (bl || drawableLegendItem.getWidth() < this.dimension - d) {
                drawableLegendItem.setX(d);
                drawableLegendItem.setY(d2);
                d += drawableLegendItem.getWidth();
                d3 = Math.max(d3, drawableLegendItem.getHeight());
                bl = false;
                continue;
            }
            d2 += d3;
            d3 = drawableLegendItem.getHeight();
            drawableLegendItem.setX(0.0);
            d = drawableLegendItem.getWidth();
        }
    }

    private void doVerticalLayout(LegendItemCollection legendItemCollection) {
        Iterator iterator = legendItemCollection.iterator();
        boolean bl = true;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        while (iterator.hasNext()) {
            DrawableLegendItem drawableLegendItem = (DrawableLegendItem)iterator.next();
            if (bl || drawableLegendItem.getHeight() < this.dimension - d2) {
                drawableLegendItem.setX(d);
                drawableLegendItem.setY(d2);
                d2 += drawableLegendItem.getHeight();
                d3 = Math.max(d3, drawableLegendItem.getWidth());
                bl = false;
                continue;
            }
            d += d3;
            d3 = drawableLegendItem.getWidth();
            drawableLegendItem.setY(0.0);
            d2 = drawableLegendItem.getHeight();
        }
    }
}

