/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_tokai.fb.w3.common.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.ImageControllEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.ImageControllListener;

public class ImageControllPanel
extends JPanel {
    protected int delay = 100;
    private JButton playButton = null;
    private JButton pauseButton = null;
    private JButton stopButton = null;
    private JButton nextButton = null;
    private JButton backButton = null;
    private JSpinner jSpinner = null;
    private JToolBar jToolBar = null;
    private Vector listeners = new Vector();
    private JSpinner.NumberEditor layNumberEditor = null;

    public ImageControllPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 0));
        this.add((Component)this.getJToolBar(), null);
    }

    private JButton getPlayButton() {
        if (this.playButton == null) {
            this.playButton = new JButton();
            this.playButton.setIcon(new ImageIcon(this.getClass().getResource("/jp/ac/u_tokai/fb/w3/common/images/play.png")));
            this.playButton.setToolTipText("\u518d\u751f");
            this.playButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ImageControllPanel.this.fireImageControll(new ImageControllEvent(ImageControllPanel.this.playButton, 1));
                }
            });
        }
        return this.playButton;
    }

    private JButton getPauseButton() {
        if (this.pauseButton == null) {
            this.pauseButton = new JButton();
            this.pauseButton.setIcon(new ImageIcon(this.getClass().getResource("/jp/ac/u_tokai/fb/w3/common/images/stop.png")));
            this.pauseButton.setToolTipText("\u4e00\u6642\u505c\u6b62");
            this.pauseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ImageControllPanel.this.fireImageControll(new ImageControllEvent(ImageControllPanel.this.pauseButton, 3));
                }
            });
        }
        return this.pauseButton;
    }

    private JButton getStopButton() {
        if (this.stopButton == null) {
            this.stopButton = new JButton();
            this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/jp/ac/u_tokai/fb/w3/common/images/rewind.png")));
            this.stopButton.setToolTipText("\u505c\u6b62");
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ImageControllPanel.this.fireImageControll(new ImageControllEvent(ImageControllPanel.this.stopButton, 2));
                }
            });
        }
        return this.stopButton;
    }

    private JButton getNextButton() {
        if (this.nextButton == null) {
            this.nextButton = new JButton();
            this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/jp/ac/u_tokai/fb/w3/common/images/next.png")));
            this.nextButton.setToolTipText("\u6b21");
            this.nextButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ImageControllPanel.this.fireImageControll(new ImageControllEvent(ImageControllPanel.this.nextButton, 5));
                }
            });
        }
        return this.nextButton;
    }

    private JButton getBackButton() {
        if (this.backButton == null) {
            this.backButton = new JButton();
            this.backButton.setIcon(new ImageIcon(this.getClass().getResource("/jp/ac/u_tokai/fb/w3/common/images/back.png")));
            this.backButton.setToolTipText("\u524d");
            this.backButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ImageControllPanel.this.fireImageControll(new ImageControllEvent(ImageControllPanel.this.backButton, 4));
                }
            });
        }
        return this.backButton;
    }

    private JSpinner getJSpinner() {
        if (this.jSpinner == null) {
            this.jSpinner = new JSpinner();
            this.jSpinner.setModel(new SpinnerNumberModel(this.delay, 50, 1000, 10));
            this.jSpinner.setPreferredSize(new Dimension(60, 0));
            this.jSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    try {
                        int t = (Integer)((JSpinner)e.getSource()).getValue();
                        if (t == ImageControllPanel.this.delay) {
                            return;
                        }
                        if (t >= 50 && t <= 1000) {
                            ImageControllPanel.this.delay = t;
                            ImageControllPanel.this.fireImageControll(new ImageControllEvent(ImageControllPanel.this.jSpinner, 6, ImageControllPanel.this.delay));
                        } else {
                            ImageControllPanel.this.jSpinner.setValue(new Integer(ImageControllPanel.this.delay));
                        }
                    }
                    catch (Exception e1) {
                        ImageControllPanel.this.jSpinner.setValue(new Integer(ImageControllPanel.this.delay));
                    }
                }
            });
        }
        return this.jSpinner;
    }

    private JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jToolBar = new JToolBar();
            this.jToolBar.add(this.getPlayButton());
            this.jToolBar.add(this.getPauseButton());
            this.jToolBar.add(this.getStopButton());
            this.jToolBar.add(this.getBackButton());
            this.jToolBar.add(this.getNextButton());
            this.jToolBar.add(this.getJSpinner());
            this.jToolBar.setFloatable(false);
        }
        return this.jToolBar;
    }

    public void addImageControllListener(ImageControllListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeImageControllListener(ImageControllListener listener) {
        this.listeners.removeElement(listener);
    }

    public void fireImageControll(ImageControllEvent e) {
        Vector listeners_t = (Vector)this.listeners.clone();
        Enumeration enumeration = listeners_t.elements();
        while (enumeration.hasMoreElements()) {
            ImageControllListener listener = (ImageControllListener)enumeration.nextElement();
            switch (e.getId()) {
                case 1: {
                    listener.playButtonPressed(e);
                    break;
                }
                case 2: {
                    listener.stopButtonPressed(e);
                    break;
                }
                case 3: {
                    listener.pauseButtonPressed(e);
                    break;
                }
                case 4: {
                    listener.backButtonPressed(e);
                    break;
                }
                case 5: {
                    listener.nextButtonPressed(e);
                    break;
                }
                case 6: {
                    listener.delayChanged(e);
                    break;
                }
            }
        }
    }

    public void setDelay(int delay) {
        this.jSpinner.setValue(new Integer(delay));
    }

    public int getDelay() {
        return this.delay;
    }
}

