/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_tokai.fb.w3.common.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import jp.ac.u_tokai.fb.w3.common.swing.CheckBoxListModel;

public class CheckBoxListCellRenderer
extends JPanel
implements ListCellRenderer {
    protected JLabel nameLabel = null;
    protected JCheckBox checkBox = null;
    private EmptyBorder ivjNoBorder = null;

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        CheckBoxListModel checkBoxListModel = (CheckBoxListModel)list.getModel();
        this.checkBox.setSelected(checkBoxListModel.isSelectedAt(index));
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        this.setBorder(cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : this.getIvjNoBorder());
        if (value != null) {
            this.nameLabel.setText(value.toString());
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        return this;
    }

    public CheckBoxListCellRenderer() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.getNameLabel(), "Center");
        this.add((Component)this.getCheckBox(), "West");
        this.setBorder(this.getIvjNoBorder());
    }

    private JLabel getNameLabel() {
        if (this.nameLabel == null) {
            this.nameLabel = new JLabel();
        }
        return this.nameLabel;
    }

    private JCheckBox getCheckBox() {
        if (this.checkBox == null) {
            this.checkBox = new JCheckBox();
            this.checkBox.setOpaque(false);
        }
        return this.checkBox;
    }

    private EmptyBorder getIvjNoBorder() {
        if (this.ivjNoBorder == null) {
            this.ivjNoBorder = new EmptyBorder(1, 1, 1, 1);
        }
        return this.ivjNoBorder;
    }
}

