/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_tokai.fb.w3.common.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jp.ac.u_tokai.fb.w3.common.swing.CheckBoxList;
import jp.ac.u_tokai.fb.w3.common.swing.CheckBoxListCellRenderer;
import jp.ac.u_tokai.fb.w3.common.swing.CheckBoxListModel;
import org.jfree.chart.renderer.XYItemRenderer;

public class EventItemListCellRenderer
extends CheckBoxListCellRenderer
implements ListCellRenderer {
    private SeriesColorIcon seriesColorIcon = null;
    private XYItemRenderer xYItemRenderer = null;
    private boolean isSelected = false;
    private int index = 0;

    public EventItemListCellRenderer() {
        this.initialize();
    }

    public EventItemListCellRenderer(XYItemRenderer renderer) {
        this();
        this.setXYItemRenderer(renderer);
    }

    private void initialize() {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        CheckBoxListModel checkBoxListModel = (CheckBoxListModel)list.getModel();
        CheckBoxList checkBoxList = (CheckBoxList)list;
        int[] indices = checkBoxList.getSelectedCheckBoxIndices();
        this.isSelected = checkBoxListModel.isSelectedAt(index);
        if (index != -1 && this.isSelected) {
            int i = 0;
            while (i < indices.length) {
                if (index == indices[i]) {
                    this.index = i;
                    break;
                }
                ++i;
            }
        }
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public XYItemRenderer getXYItemRenderer() {
        return this.xYItemRenderer;
    }

    public void setXYItemRenderer(XYItemRenderer renderer) {
        this.xYItemRenderer = renderer;
        this.nameLabel.setIcon(new SeriesColorIcon(this, renderer));
    }

    class SeriesColorIcon
    implements Icon {
        private EventItemListCellRenderer cellRenderer;
        private XYItemRenderer renderer;
        private int width = 8;
        private int height = 8;
        private Color fillColor;

        public SeriesColorIcon(Color fillColor) {
            this.fillColor = fillColor;
        }

        public SeriesColorIcon(EventItemListCellRenderer cellRenderer, XYItemRenderer renderer) {
            this.cellRenderer = cellRenderer;
            this.renderer = renderer;
        }

        public int getIconHeight() {
            return this.height;
        }

        public int getIconWidth() {
            return this.width;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.cellRenderer.isSelected) {
                g.setColor((Color)this.renderer.getSeriesPaint(this.cellRenderer.getIndex()));
                g.fillOval(x, y, this.width, this.height);
            }
        }
    }
}

