/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_tokai.fb.w3.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import jp.ac.u_tokai.fb.w3.bixpp.schema.BIXppBase;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver10.BioInformationExchangeForPlantProduction;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.BIXpp;
import jp.ac.u_tokai.fb.w3.common.BIXppVersionChecker;
import jp.ac.u_tokai.fb.w3.common.DifferentVersionException;
import jp.ac.u_tokai.fb.w3.common.swing.event.BixppOpenEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.BixppOpenListener;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class BIXppOpener {
    private double version = 0.0;
    private URI uri;
    private BIXppVersionChecker bixppVersionChecker;
    private InputStreamReader reader;
    private BIXppBase bixpp;
    private Vector listeners = new Vector();

    public BIXppOpener() {
        this.bixppVersionChecker = new BIXppVersionChecker();
    }

    public BIXppBase open(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            return this.open(file.toURI());
        }
        return null;
    }

    public BIXppBase open(String fileName, double frontVersion, double endVersion) throws DifferentVersionException {
        BIXppBase bixppBase = this.open(fileName);
        if (this.version < frontVersion || this.version > endVersion) {
            throw new DifferentVersionException("\u6307\u5b9a\u30d0\u30fc\u30b8\u30e7\u30f3\u4ee5\u5916\u306eBix-pp\u30d5\u30a1\u30a4\u30eb\u3067\u3059\u3002");
        }
        return bixppBase;
    }

    public BIXppBase open(URI fileURI) {
        this.bixpp = null;
        this.uri = fileURI;
        try {
            this.reader = new InputStreamReader(fileURI.toURL().openStream(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.version = this.bixppVersionChecker.getBIXppVersion(fileURI);
        try {
            if (this.version >= 1.0 && this.version < 2.0) {
                this.bixpp = BioInformationExchangeForPlantProduction.unmarshal(this.reader).getBIXPp();
            } else if (this.version >= 2.0 && this.version < 3.0) {
                this.bixpp = (BIXppBase)BIXpp.unmarshal(this.reader);
                this.fireBixppOpen(new BixppOpenEvent(this, (BIXpp)this.bixpp, this.uri));
            }
        }
        catch (MarshalException e1) {
            e1.printStackTrace();
            JOptionPane.showMessageDialog(null, "BIX-pp\u306e\u6587\u6cd5\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002", "XML\u51e6\u7406\u30a8\u30e9\u30fc", 0);
        }
        catch (ValidationException e1) {
            e1.printStackTrace();
            JOptionPane.showMessageDialog(null, "XML\u304c\u6b63\u898f\u5316\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002", "XML\u51e6\u7406\u30a8\u30e9\u30fc", 0);
        }
        return this.bixpp;
    }

    public BIXppBase open(URI fileURI, double frontVersion, double endVersion) throws DifferentVersionException {
        BIXppBase bixppBase = this.open(fileURI);
        if (this.version < frontVersion || this.version > endVersion) {
            throw new DifferentVersionException("\u6307\u5b9a\u30d0\u30fc\u30b8\u30e7\u30f3\u4ee5\u5916\u306eBix-pp\u30d5\u30a1\u30a4\u30eb\u3067\u3059\u3002");
        }
        return bixppBase;
    }

    public void addBixppOpenListener(BixppOpenListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeBixppOpenListener(BixppOpenListener listener) {
        this.listeners.removeElement(listener);
    }

    private void fireBixppOpen(BixppOpenEvent e) {
        Vector listeners_t = (Vector)this.listeners.clone();
        Enumeration enumeration = listeners_t.elements();
        while (enumeration.hasMoreElements()) {
            BixppOpenListener listener = (BixppOpenListener)enumeration.nextElement();
            listener.bixppOpened(e);
        }
    }

    public double test(URI fileURI) {
        return this.bixppVersionChecker.getBIXppVersion(fileURI);
    }
}

