/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_tokai.fb.w3.bixcomposite.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import jp.ac.u_tokai.fb.w3.bixcomposite.swing.InnerImageSelectable;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.BIXpp;
import jp.ac.u_tokai.fb.w3.common.swing.ImagePanel;
import jp.ac.u_tokai.fb.w3.common.swing.event.BixppOpenEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.BixppOpenListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.ChangeDateEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.ChangeDateListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectImageItemEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectImageItemListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectInnerImageEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectInnerImageListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectSamplingRateEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectSamplingRateListener;

public class InnerImagePanel
extends JPanel
implements BixppOpenListener,
ChangeDateListener,
SelectImageItemListener,
SelectSamplingRateListener,
InnerImageSelectable {
    private int recordIndex;
    private Vector listeners = new Vector();
    private BIXpp bixpp = null;
    private ImagePanel imagePanel = null;
    private JTextArea textArea = null;

    public InnerImagePanel() {
        this.initialize();
    }

    public InnerImagePanel(int index) {
        this();
        this.setImageItemIndex(index);
    }

    private void initialize() {
        GridBagConstraints consGridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints consGridBagConstraints1 = new GridBagConstraints();
        consGridBagConstraints2.gridx = 0;
        consGridBagConstraints2.gridy = 1;
        consGridBagConstraints1.gridx = 0;
        consGridBagConstraints1.gridy = 0;
        consGridBagConstraints1.fill = 1;
        consGridBagConstraints1.weightx = 1.0;
        consGridBagConstraints1.weighty = 1.0;
        consGridBagConstraints1.insets = new Insets(5, 5, 0, 5);
        consGridBagConstraints2.insets = new Insets(2, 3, 3, 3);
        consGridBagConstraints2.fill = 2;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getImagePanel(), consGridBagConstraints1);
        this.add((Component)this.getTextArea(), consGridBagConstraints2);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                InnerImagePanel.this.fireSelectInnerImageEvent(new SelectInnerImageEvent(this, InnerImagePanel.this.imagePanel.getImageItemIndex(), InnerImagePanel.this.recordIndex));
            }

            public void mouseExited(MouseEvent e) {
                InnerImagePanel.this.setBackground(SystemColor.control);
            }

            public void mouseEntered(MouseEvent e) {
                InnerImagePanel.this.setBackground(SystemColor.textHighlight);
            }
        });
    }

    private ImagePanel getImagePanel() {
        if (this.imagePanel == null) {
            this.imagePanel = new ImagePanel();
            this.imagePanel.setPreferredSize(new Dimension(160, 120));
        }
        return this.imagePanel;
    }

    public void bixppOpened(BixppOpenEvent e) {
        this.bixpp = e.getBixpp();
        this.imagePanel.bixppOpened(e);
    }

    public void recordIndexChanged(ChangeDateEvent e) {
        this.imagePanel.recordIndexChanged(e);
        this.recordIndex = e.getRecordIndex();
    }

    public void setImageItemIndex(int i) {
        this.imagePanel.setImageItemIndex(i);
    }

    public int getImageItemIndex() {
        return this.imagePanel.getImageItemIndex();
    }

    private JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
            this.textArea.setLineWrap(true);
            this.textArea.setEditable(false);
            this.textArea.setMargin(new Insets(0, 4, 0, 4));
            this.textArea.setOpaque(true);
            this.textArea.setDoubleBuffered(true);
        }
        return this.textArea;
    }

    public void imageItemSelected(SelectImageItemEvent e) {
        this.imagePanel.imageItemSelected(e);
        this.textArea.setText(e.getImageItems()[0].getName());
    }

    public void samplingRateSelected(SelectSamplingRateEvent e) {
        this.imagePanel.samplingRateSelected(e);
        this.textArea.setPreferredSize(null);
    }

    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.imagePanel.getUrl() != null) {
            size.width = Math.max(this.imagePanel.getPreferredSize().width + 5 + 5, 80);
        } else {
            size.width = 80;
            size.height = this.textArea.getPreferredSize().height + 5 + 5;
        }
        return size;
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public void addSelectInnerImageListener(SelectInnerImageListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeSelectInnerImageListener(SelectInnerImageListener listener) {
        this.listeners.removeElement(listener);
    }

    private void fireSelectInnerImageEvent(SelectInnerImageEvent e) {
        Enumeration enumeration = ((Vector)this.listeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((SelectInnerImageListener)enumeration.nextElement()).innerImageSelected(e);
        }
    }
}

