/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.u_tokai.fb.w3.bixcomposite.swing;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.net.URI;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jp.ac.u_tokai.fb.w3.bixcomposite.swing.InnerImagePanel;
import jp.ac.u_tokai.fb.w3.bixcomposite.swing.InnerImageSelectable;
import jp.ac.u_tokai.fb.w3.bixpp.schema.ver20.BIXpp;
import jp.ac.u_tokai.fb.w3.common.swing.FlowScrollLayout;
import jp.ac.u_tokai.fb.w3.common.swing.event.BixppOpenEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.BixppOpenListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.ChangeDateEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.ChangeDateListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectImageItemEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectImageItemListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectInnerImageEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectInnerImageListener;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectSamplingRateEvent;
import jp.ac.u_tokai.fb.w3.common.swing.event.SelectSamplingRateListener;

public class ImageCompositePanel
extends JPanel
implements BixppOpenListener,
ChangeDateListener,
SelectImageItemListener,
SelectSamplingRateListener,
SelectInnerImageListener,
InnerImageSelectable {
    private int recordIndex;
    private int samplingRate = 1;
    private Vector listeners = new Vector();
    private JScrollPane scrollPane;
    private URI path;
    private Vector innerImagePanelList;
    private BIXpp bixpp;
    private FlowScrollLayout flowScrollLayout = null;

    public ImageCompositePanel() {
        this.initialize();
    }

    private void initialize() {
        this.flowScrollLayout = new FlowScrollLayout();
        this.flowScrollLayout.setAlignment(0);
        this.flowScrollLayout.setUniformHeight(false);
        this.setLayout(this.flowScrollLayout);
        this.innerImagePanelList = new Vector();
    }

    public void setScrollPane(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
        this.flowScrollLayout.setScrollPane(scrollPane);
    }

    public void bixppOpened(BixppOpenEvent e) {
        this.bixpp = e.getBixpp();
        this.path = e.getPath();
        this.removeAll();
        this.innerImagePanelList.removeAllElements();
    }

    public void recordIndexChanged(ChangeDateEvent e) {
        this.recordIndex = e.getRecordIndex();
        int i = 0;
        while (i < this.innerImagePanelList.size()) {
            ((InnerImagePanel)this.innerImagePanelList.get(i)).recordIndexChanged(e);
            ++i;
        }
        if (this.scrollPane != null) {
            this.scrollPane.revalidate();
        }
    }

    public void imageItemSelected(SelectImageItemEvent e) {
        this.removeAll();
        this.innerImagePanelList.removeAllElements();
        if (e.getImageItems().length > 0) {
            BixppOpenEvent bixppOpenEvent = new BixppOpenEvent(this, this.bixpp, this.path);
            SelectSamplingRateEvent selectSamplingRateEvent = new SelectSamplingRateEvent(this, this.samplingRate);
            ChangeDateEvent changeDateEvent = new ChangeDateEvent(this, this.bixpp, this.recordIndex);
            int i = 0;
            while (i < e.getImageItems().length) {
                InnerImagePanel innerImagePanel = new InnerImagePanel();
                innerImagePanel.bixppOpened(bixppOpenEvent);
                innerImagePanel.imageItemSelected(new SelectImageItemEvent((Object)this, e.getImageItems()[i]));
                innerImagePanel.samplingRateSelected(selectSamplingRateEvent);
                innerImagePanel.recordIndexChanged(changeDateEvent);
                innerImagePanel.addSelectInnerImageListener(this);
                innerImagePanel.addComponentListener(new ComponentAdapter(){

                    public void componentResized(ComponentEvent e) {
                        ImageCompositePanel.this.revalidate();
                    }
                });
                this.innerImagePanelList.addElement(innerImagePanel);
                this.add(innerImagePanel);
                ++i;
            }
        }
        if (this.scrollPane != null) {
            this.scrollPane.revalidate();
        }
        this.repaint();
    }

    public void samplingRateSelected(SelectSamplingRateEvent e) {
        this.samplingRate = e.getSamplingRate();
        int i = 0;
        while (i < this.innerImagePanelList.size()) {
            ((InnerImagePanel)this.innerImagePanelList.get(i)).samplingRateSelected(e);
            ++i;
        }
        if (this.scrollPane != null) {
            this.scrollPane.revalidate();
        }
    }

    public void addSelectInnerImageListener(SelectInnerImageListener listener) {
        this.listeners.addElement(listener);
    }

    public void removeSelectInnerImageListener(SelectInnerImageListener listener) {
        this.listeners.removeElement(listener);
    }

    private void fireSelectInnerImageEvent(SelectInnerImageEvent e) {
        Enumeration enumeration = ((Vector)this.listeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((SelectInnerImageListener)enumeration.nextElement()).innerImageSelected(e);
        }
    }

    public void innerImageSelected(SelectInnerImageEvent e) {
        this.fireSelectInnerImageEvent(e);
    }
}

