/*
 * Decompiled with CFR 0.152.
 */
package com.simontuffs.onejar;

import com.simontuffs.onejar.Handler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class JarClassLoader
extends ClassLoader {
    public static final String JAVA_CLASS_PATH = "java.class.path";
    public static final String LIB_PREFIX = "lib/";
    public static final String MAIN_PREFIX = "main/";
    public static final String RECORDING = "recording";
    public static final String TMP = "tmp";
    public static final String UNPACK = "unpack";
    public static final String EXPAND = "One-Jar-Expand";
    public static final String CLASS = ".class";
    public static final String JAVA_PROTOCOL_HANDLER = "java.protocol.handler.pkgs";
    protected String name;
    protected Map byteCode = new HashMap();
    protected Map pdCache = Collections.synchronizedMap(new HashMap());
    protected boolean record = false;
    protected boolean flatten = false;
    protected boolean unpackFindResource = false;
    protected boolean verbose = false;
    protected boolean info = false;
    protected String recording = "recording";
    protected String jarName;
    protected String mainJar;
    protected String wrapDir;
    protected boolean delegateToParent;
    protected boolean classPool = false;
    static /* synthetic */ Class class$0;

    static {
        String handlerPackage = System.getProperty(JAVA_PROTOCOL_HANDLER);
        if (handlerPackage == null) {
            handlerPackage = "";
        }
        if (handlerPackage.length() > 0) {
            handlerPackage = "|" + handlerPackage;
        }
        handlerPackage = "com.simontuffs" + handlerPackage;
        System.setProperty(JAVA_PROTOCOL_HANDLER, handlerPackage);
    }

    protected String PREFIX() {
        return "JarClassLoader: ";
    }

    protected String NAME() {
        return this.name != null ? "'" + this.name + "' " : "";
    }

    protected void VERBOSE(String message) {
        if (this.verbose) {
            System.out.println(String.valueOf(this.PREFIX()) + this.NAME() + message);
        }
    }

    protected void WARNING(String message) {
        System.err.println(String.valueOf(this.PREFIX()) + "Warning: " + this.NAME() + message);
    }

    protected void INFO(String message) {
        if (this.info) {
            System.out.println(String.valueOf(this.PREFIX()) + "Info: " + this.NAME() + message);
        }
    }

    public JarClassLoader(String $wrap) {
        this.wrapDir = $wrap;
        this.delegateToParent = this.wrapDir == null;
    }

    public JarClassLoader(ClassLoader parent) {
        super(parent);
        this.delegateToParent = true;
    }

    public String load(String mainClass) {
        return this.load(mainClass, null);
    }

    public String load(String mainClass, String jarName) {
        if (this.record) {
            new File(this.recording).mkdirs();
        }
        try {
            if (jarName == null) {
                jarName = System.getProperty(JAVA_CLASS_PATH);
            }
            JarFile jarFile = new JarFile(jarName);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            Manifest manifest = jarFile.getManifest();
            String[] expandPaths = null;
            String expand = manifest.getMainAttributes().getValue(EXPAND);
            if (expand != null) {
                this.VERBOSE("One-Jar-Expand=" + expand);
                expandPaths = expand.split(",");
            }
            while (enumeration.hasMoreElements()) {
                InputStream is;
                JarEntry entry = enumeration.nextElement();
                if (entry.isDirectory()) continue;
                boolean expanded = false;
                String name = entry.getName();
                if (expandPaths != null) {
                    int i = 0;
                    while (i < expandPaths.length) {
                        if (name.startsWith(expandPaths[i])) {
                            File dest = new File(name);
                            if (!dest.exists() || dest.lastModified() < entry.getTime()) {
                                this.INFO("Expanding " + name);
                                if (dest.exists()) {
                                    this.INFO("Update because lastModified=" + new Date(dest.lastModified()) + ", entry=" + new Date(entry.getTime()));
                                }
                                dest.getParentFile().mkdirs();
                                this.VERBOSE("using jarFile.getInputStream(" + entry + ")");
                                InputStream is2 = jarFile.getInputStream(entry);
                                FileOutputStream os = new FileOutputStream(dest);
                                this.copy(is2, os);
                                is2.close();
                                os.close();
                            } else {
                                this.VERBOSE(String.valueOf(name) + " already expanded");
                            }
                            expanded = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (expanded) continue;
                String jar = entry.getName();
                if (this.wrapDir != null && jar.startsWith(this.wrapDir) || jar.startsWith(LIB_PREFIX) || jar.startsWith(MAIN_PREFIX)) {
                    if (this.wrapDir != null && !entry.getName().startsWith(this.wrapDir)) continue;
                    this.INFO("caching " + jar);
                    this.VERBOSE("using jarFile.getInputStream(" + entry + ")");
                    is = jarFile.getInputStream(entry);
                    if (is == null) {
                        throw new IOException("Unable to load resource /" + jar + " using " + this);
                    }
                    this.loadByteCode(is, jar);
                    if (!jar.startsWith(MAIN_PREFIX)) continue;
                    if (mainClass == null) {
                        JarInputStream jis = new JarInputStream(jarFile.getInputStream(entry));
                        mainClass = jis.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                        this.mainJar = jar;
                        continue;
                    }
                    if (this.mainJar == null) continue;
                    this.WARNING("A main class is defined in multiple jar files inside main/" + this.mainJar + " and " + jar);
                    this.WARNING("The main class " + mainClass + " from " + this.mainJar + " will be used");
                    continue;
                }
                if (this.wrapDir == null && name.startsWith(UNPACK)) {
                    is = this.getClass().getResourceAsStream("/" + jar);
                    if (is == null) {
                        throw new IOException(jar);
                    }
                    File dir = new File(TMP);
                    File sentinel = new File(dir, jar.replace('/', '.'));
                    if (sentinel.exists()) continue;
                    this.INFO("unpacking " + jar + " into " + dir.getCanonicalPath());
                    this.loadByteCode(is, jar, TMP);
                    sentinel.getParentFile().mkdirs();
                    sentinel.createNewFile();
                    continue;
                }
                if (!name.endsWith(CLASS)) continue;
                this.loadBytes(entry, jarFile.getInputStream(entry), "/", null);
            }
            if (mainClass == null) {
                mainClass = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            }
        }
        catch (IOException iox) {
            System.err.println("Unable to load resource: " + iox);
            iox.printStackTrace(System.err);
        }
        return mainClass;
    }

    protected void loadByteCode(InputStream is, String jar) throws IOException {
        this.loadByteCode(is, jar, null);
    }

    protected void loadByteCode(InputStream is, String jar, String tmp) throws IOException {
        JarInputStream jis = new JarInputStream(is);
        JarEntry entry = null;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            this.loadBytes(entry, jis, jar, tmp);
        }
    }

    protected void loadBytes(JarEntry entry, InputStream is, String jar, String tmp) throws IOException {
        String entryName = entry.getName().replace('/', '.');
        int index = entryName.lastIndexOf(46);
        String type = entryName.substring(index + 1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.copy(is, baos);
        if (tmp != null) {
            File file = new File(tmp, entry.getName());
            file.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(baos.toByteArray());
            fos.close();
        } else {
            byte[] bytes = baos.toByteArray();
            if (type.equals("class")) {
                if (this.alreadyCached(entryName, jar, bytes)) {
                    return;
                }
                this.byteCode.put(entryName, new ByteCode(entryName, entry.getName(), bytes, jar));
                this.VERBOSE("cached bytes for class " + entryName);
            } else {
                String localname = String.valueOf(jar) + "/" + entryName;
                this.byteCode.put(localname, new ByteCode(localname, entry.getName(), bytes, jar));
                this.VERBOSE("cached bytes for local name " + localname);
                if (this.alreadyCached(entryName, jar, bytes)) {
                    return;
                }
                this.byteCode.put(entryName, new ByteCode(entryName, entry.getName(), bytes, jar));
                this.VERBOSE("cached bytes for entry name " + entryName);
            }
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> cls = this.findLoadedClass(name);
        if (cls != null) {
            return cls;
        }
        this.VERBOSE("findClass(" + name + ")");
        String cache = String.valueOf(name.replace('/', '.')) + CLASS;
        ByteCode bytecode = (ByteCode)this.byteCode.get(cache);
        if (bytecode != null) {
            ProtectionDomain pd;
            this.VERBOSE("found " + name + " in codebase '" + bytecode.codebase + "'");
            if (this.record) {
                this.record(bytecode);
            }
            if ((pd = (ProtectionDomain)this.pdCache.get(bytecode.codebase)) == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.simontuffs.onejar.JarClassLoader");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                ProtectionDomain cd = clazz.getProtectionDomain();
                URL url = cd.getCodeSource().getLocation();
                try {
                    url = new URL("jar:" + url + "!/" + bytecode.codebase);
                }
                catch (MalformedURLException mux) {
                    mux.printStackTrace(System.out);
                }
                CodeSource source = new CodeSource(url, null);
                pd = new ProtectionDomain(source, null, this, null);
                this.pdCache.put(bytecode.codebase, pd);
            }
            byte[] bytes = bytecode.bytes;
            return this.defineClass(name, bytes, pd);
        }
        this.VERBOSE(String.valueOf(name) + " not found");
        throw new ClassNotFoundException(name);
    }

    protected Class defineClass(String name, byte[] bytes, ProtectionDomain pd) throws ClassFormatError {
        return this.defineClass(name, bytes, 0, bytes.length, pd);
    }

    protected void record(ByteCode bytecode) {
        String fileName;
        File dir = new File(this.recording, this.flatten ? "" : bytecode.codebase);
        File file = new File(dir, fileName = bytecode.original);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            this.VERBOSE("" + file);
            try {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(bytecode.bytes);
                fos.close();
            }
            catch (IOException iox) {
                System.err.println(String.valueOf(this.PREFIX()) + "unable to record " + file + ": " + iox);
            }
        }
    }

    public InputStream getByteStream(String resource) {
        InputStream result = null;
        ByteCode bytecode = (ByteCode)this.byteCode.get(resource);
        if (bytecode == null) {
            bytecode = (ByteCode)this.byteCode.get(this.resolve(resource));
        }
        if (bytecode != null) {
            result = new ByteArrayInputStream(bytecode.bytes);
        }
        if (result == null && this.delegateToParent) {
            result = ((JarClassLoader)this.getParent()).getByteStream(resource);
        }
        this.VERBOSE("getByteStream(" + resource + ") -> " + result);
        return result;
    }

    protected String resolve(String $resource) {
        String tmp;
        if ($resource.startsWith("/")) {
            $resource = $resource.substring(1);
        }
        $resource = $resource.replace('/', '.');
        String resource = null;
        String caller = this.getCaller();
        ByteCode callerCode = (ByteCode)this.byteCode.get(String.valueOf(caller) + CLASS);
        if (callerCode != null && this.byteCode.get(tmp = String.valueOf(callerCode.codebase) + "/" + $resource) != null) {
            resource = tmp;
        }
        if (resource == null) {
            resource = this.byteCode.get($resource) == null ? null : $resource;
        }
        this.VERBOSE("resource " + $resource + " resolved to " + resource);
        return resource;
    }

    protected boolean alreadyCached(String name, String jar, byte[] bytes) {
        ByteCode existing = (ByteCode)this.byteCode.get(name);
        if (existing != null) {
            if (!Arrays.equals(existing.bytes, bytes) && !name.startsWith("/META-INF")) {
                this.INFO(String.valueOf(existing.name) + " in " + jar + " is hidden by " + existing.codebase + " (with different bytecode)");
            } else {
                this.VERBOSE(String.valueOf(existing.name) + " in " + jar + " is hidden by " + existing.codebase + " (with same bytecode)");
            }
            return true;
        }
        return false;
    }

    protected String getCaller() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        String caller = null;
        int i = 0;
        while (i < stack.length) {
            if (this.byteCode.get(String.valueOf(stack[i].getClassName()) + CLASS) != null) {
                caller = stack[i].getClassName();
                break;
            }
            ++i;
        }
        return caller;
    }

    public void setRecording(String $recording) {
        this.recording = $recording;
        if (this.recording == null) {
            this.recording = RECORDING;
        }
    }

    public String getRecording() {
        return this.recording;
    }

    public void setRecord(boolean $record) {
        this.record = $record;
    }

    public boolean getRecord() {
        return this.record;
    }

    public void setFlatten(boolean $flatten) {
        this.flatten = $flatten;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public void setVerbose(boolean $verbose) {
        this.info = this.verbose = $verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setInfo(boolean $info) {
        this.info = $info;
    }

    public boolean getInfo() {
        return this.info;
    }

    protected URL findResource(String $resource) {
        try {
            this.INFO("findResource(" + $resource + ")");
            String resource = this.resolve($resource);
            if (resource != null) {
                this.INFO("findResource() found: " + $resource);
                return new URL(String.valueOf(Handler.PROTOCOL) + ":" + resource);
            }
            this.INFO("findResource(): unable to locate " + $resource);
            return null;
        }
        catch (MalformedURLException mux) {
            this.WARNING("unable to locate " + $resource + " due to " + mux);
            return null;
        }
    }

    protected void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + (this.name != null ? "(" + this.name + ")" : "");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected class ByteCode {
        public byte[] bytes;
        public String name;
        public String original;
        public String codebase;

        public ByteCode(String $name, String $original, byte[] $bytes, String $codebase) {
            this.name = $name;
            this.original = $original;
            this.bytes = $bytes;
            this.codebase = $codebase;
        }
    }
}

