/*
 * Decompiled with CFR 0.152.
 */
package info.bix.tokai.bixpp.binding;

import info.bix.tokai.bixpp.binding.Item;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang.Validate;

public class Record
implements Serializable {
    private static final long serialVersionUID = -4306532735122060494L;
    private double _days = 0.0;
    private ArrayList<Item> _itemList = new ArrayList();

    public Record() {
    }

    public void addItem(Item vItem) throws IndexOutOfBoundsException {
        Validate.notNull(vItem);
        this._itemList.add(vItem);
    }

    public void addItem(int index, Item vItem) throws IndexOutOfBoundsException {
        Validate.notNull(vItem);
        this._itemList.add(index, vItem);
    }

    public void clearItem() {
        this._itemList.clear();
    }

    public double getDays() {
        return this._days;
    }

    public Item getItem(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._itemList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this._itemList.get(index);
    }

    public Item[] getItem() {
        int size = this._itemList.size();
        Item[] mArray = new Item[size];
        int index = 0;
        while (index < size) {
            mArray[index] = this._itemList.get(index);
            ++index;
        }
        return mArray;
    }

    public int getItemCount() {
        return this._itemList.size();
    }

    public boolean removeItem(Item vItem) {
        boolean removed = this._itemList.remove(vItem);
        return removed;
    }

    public void setDays(double days) {
        this._days = days;
    }

    public void setItem(int index, Item vItem) throws IndexOutOfBoundsException {
        Validate.notNull(vItem);
        if (index < 0 || index > this._itemList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._itemList.set(index, vItem);
    }

    public void setItem(Item[] itemArray) {
        Validate.notNull(itemArray);
        this._itemList.clear();
        int i = 0;
        while (i < itemArray.length) {
            this._itemList.add(itemArray[i]);
            ++i;
        }
    }

    public Item getItemByIndex(long index) {
        for (Item item : this._itemList) {
            if (item.getIndex() != index) continue;
            return item;
        }
        return null;
    }

    public Record(double days) {
        this();
        this.setDays(days);
    }
}

