/*
 * Decompiled with CFR 0.152.
 */
package info.bix.tokai.bixpp.binding;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;

public class HexHeader
implements Serializable {
    private static final long serialVersionUID = -1926800014186751411L;
    private String _name;
    private String _recordFormat = "";
    private byte[] _hex = new byte[0];

    public byte[] getHex() {
        return this._hex;
    }

    public String getName() {
        return this._name;
    }

    public String getRecordFormat() {
        return this._recordFormat;
    }

    public void setHex(byte[] hex) {
        Validate.notNull(hex);
        this._hex = hex;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setRecordFormat(String recordFormat) {
        Validate.notNull(recordFormat);
        this._recordFormat = recordFormat;
    }

    public void setHex(File file) throws IOException {
        Validate.notNull(file);
        FileInputStream inputStream = new FileInputStream(file);
        this.setHex(inputStream);
    }

    public void setHex(URL url) throws IOException {
        Validate.notNull(url);
        this.setHex(url.openStream());
    }

    public void setHex(InputStream inputStream) throws IOException {
        Validate.notNull(inputStream);
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            IOUtils.copy(inputStream, (OutputStream)outputStream);
            this.setHex(outputStream.toByteArray());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(outputStream);
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(outputStream);
        IOUtils.closeQuietly(inputStream);
    }
}

