/*
 * Decompiled with CFR 0.152.
 */
package info.bix.tokai.bixpp.binding;

import info.bix.tokai.bixpp.binding.Cultivation;
import info.bix.tokai.bixpp.binding.Farm;
import info.bix.tokai.bixpp.binding.Producer;
import info.bix.tokai.bixpp.binding.RecordSet;
import info.bix.tokai.bixpp.binding.RecordingDefinition;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.Validate;

public class BIXpp
implements Serializable {
    private static final long serialVersionUID = -6242180068961576663L;
    private float _version = 3.0f;
    private Date _create = new Date();
    private Date _update = new Date();
    private Date _complete;
    private Producer _producer = new Producer();
    private Farm _farm = new Farm();
    private ArrayList<Cultivation> _cultivationList = new ArrayList();
    private Date start = new Date();
    private RecordingDefinition _recordingDefinition = new RecordingDefinition();
    private RecordSet _recordSet = new RecordSet();
    private URL fileURL;

    public void addCultivation(Cultivation vCultivation) throws IndexOutOfBoundsException {
        Validate.notNull(vCultivation);
        this._cultivationList.add(vCultivation);
    }

    public void addCultivation(int index, Cultivation vCultivation) throws IndexOutOfBoundsException {
        Validate.notNull(vCultivation);
        this._cultivationList.add(index, vCultivation);
    }

    public void clearCultivation() {
        this._cultivationList.clear();
    }

    public Date getComplete() {
        return this._complete;
    }

    public Date getCreate() {
        return this._create;
    }

    public Cultivation getCultivation(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._cultivationList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this._cultivationList.get(index);
    }

    public Cultivation[] getCultivation() {
        int size = this._cultivationList.size();
        Cultivation[] mArray = new Cultivation[size];
        int index = 0;
        while (index < size) {
            mArray[index] = this._cultivationList.get(index);
            ++index;
        }
        return mArray;
    }

    public int getCultivationCount() {
        return this._cultivationList.size();
    }

    public Farm getFarm() {
        return this._farm;
    }

    public Producer getProducer() {
        return this._producer;
    }

    public RecordSet getRecordSet() {
        return this._recordSet;
    }

    public RecordingDefinition getRecordingDefinition() {
        return this._recordingDefinition;
    }

    public Date getUpdate() {
        return this._update;
    }

    public float getVersion() {
        return this._version;
    }

    public boolean removeCultivation(Cultivation vCultivation) {
        boolean removed = this._cultivationList.remove(vCultivation);
        return removed;
    }

    public void setComplete(Date complete) {
        this._complete = complete;
    }

    public void setCreate(Date create) {
        Validate.notNull(create);
        this._create = create;
    }

    public void setCultivation(int index, Cultivation vCultivation) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._cultivationList.size()) {
            throw new IndexOutOfBoundsException();
        }
        Validate.notNull(vCultivation);
        this._cultivationList.set(index, vCultivation);
    }

    public void setCultivation(Cultivation[] cultivationArray) {
        Validate.notNull(cultivationArray);
        this._cultivationList.clear();
        int i = 0;
        while (i < cultivationArray.length) {
            this._cultivationList.add(cultivationArray[i]);
            ++i;
        }
    }

    public void setFarm(Farm farm) {
        Validate.notNull(farm);
        this._farm = farm;
    }

    public void setProducer(Producer producer) {
        Validate.notNull(producer);
        this._producer = producer;
    }

    public void setRecordSet(RecordSet recordSet) {
        Validate.notNull(recordSet);
        this._recordSet = recordSet;
    }

    public void setRecordingDefinition(RecordingDefinition recordingDefinition) {
        Validate.notNull(recordingDefinition);
        this._recordingDefinition = recordingDefinition;
    }

    public void setUpdate(Date update) {
        Validate.notNull(update);
        this._update = update;
    }

    public void setVersion(float version) {
        this._version = version;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        Validate.notNull(start);
        this.start = start;
    }

    public URL getFileURL() {
        return this.fileURL;
    }

    public void setFileURL(URL fileURL) {
        this.fileURL = fileURL;
    }
}

