/*
 * Decompiled with CFR 0.152.
 */
package info.bix.tokai.bixpp.xml;

import com.sun.msv.verifier.jarv.TheFactoryImpl;
import info.bix.tokai.bixpp.xml.SchemaLoadingException;
import info.bix.tokai.bixpp.xml.ValidationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFactory;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLValidator {
    private VerifierFactory factory = new TheFactoryImpl();
    private Schema schema;
    private Verifier verifier;
    private List<SAXParseException> saxExceptions = new ArrayList<SAXParseException>();
    private Object lock = new Object();
    private ErrorHandler errorHandler = new ErrorHandler(){

        public void warning(SAXParseException e) {
            XMLValidator.this.saxExceptions.add(e);
        }

        public void error(SAXParseException e) throws SAXException {
            XMLValidator.this.saxExceptions.add(e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            XMLValidator.this.saxExceptions.add(e);
        }
    };

    public XMLValidator(File schemaFile) throws SchemaLoadingException, IOException {
        this.setSchema(schemaFile);
    }

    public XMLValidator(URL schemURL) throws SchemaLoadingException, IOException {
        this.setSchema(schemURL);
    }

    public XMLValidator(InputSource schemaSource) throws SchemaLoadingException, IOException {
        this.setSchema(schemaSource);
    }

    public XMLValidator(InputStream schemaStream) throws SchemaLoadingException, IOException {
        this.setSchema(schemaStream);
    }

    public void setSchema(File schemaFile) throws IOException, SchemaLoadingException {
        Validate.notNull((Object)schemaFile);
        try {
            this.schema = this.factory.compileSchema(schemaFile);
            this.createVerifier();
        }
        catch (VerifierConfigurationException e) {
            throw new SchemaLoadingException(e);
        }
        catch (SAXException e) {
            throw new SchemaLoadingException(e);
        }
        catch (IOException e) {
            throw e;
        }
    }

    public void setSchema(URL schemaURL) throws IOException, SchemaLoadingException {
        Validate.notNull((Object)schemaURL);
        try {
            this.schema = this.factory.compileSchema(schemaURL.toString());
            this.createVerifier();
        }
        catch (VerifierConfigurationException e) {
            throw new SchemaLoadingException(e);
        }
        catch (SAXException e) {
            throw new SchemaLoadingException(e);
        }
        catch (IOException e) {
            throw e;
        }
    }

    public void setSchema(InputSource schemaSource) throws IOException, SchemaLoadingException {
        Validate.notNull((Object)schemaSource);
        try {
            this.schema = this.factory.compileSchema(schemaSource);
            this.createVerifier();
        }
        catch (VerifierConfigurationException e) {
            throw new SchemaLoadingException(e);
        }
        catch (SAXException e) {
            throw new SchemaLoadingException(e);
        }
        catch (IOException e) {
            throw e;
        }
    }

    public void setSchema(InputStream schemaStream) throws IOException, SchemaLoadingException {
        Validate.notNull((Object)schemaStream);
        try {
            this.schema = this.factory.compileSchema(schemaStream);
            this.createVerifier();
        }
        catch (VerifierConfigurationException e) {
            throw new SchemaLoadingException(e);
        }
        catch (SAXException e) {
            throw new SchemaLoadingException(e);
        }
        catch (IOException e) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createVerifier() throws VerifierConfigurationException {
        Object object = this.lock;
        synchronized (object) {
            this.verifier = this.schema.newVerifier();
            this.verifier.setErrorHandler(this.errorHandler);
        }
    }

    public boolean validate(File xmlFile) throws ValidationException, IOException {
        return this.verify(xmlFile);
    }

    public boolean validate(URL xmlURL) throws ValidationException, IOException {
        return this.verify(xmlURL);
    }

    public boolean validate(InputStream xmlStream) throws ValidationException, IOException {
        return this.verify(xmlStream);
    }

    public boolean validate(InputSource xmlSource) throws ValidationException, IOException {
        return this.verify(xmlSource);
    }

    public boolean validate(Node xmlNode) throws ValidationException, IOException {
        return this.verify(xmlNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verify(Object xml) throws ValidationException, IOException {
        Object object = this.lock;
        synchronized (object) {
            block17: {
                Validate.notNull((Object)xml);
                if (this.verifier != null) break block17;
                return false;
            }
            this.saxExceptions.clear();
            try {
                if (xml instanceof File) {
                    this.verifier.verify((File)xml);
                } else if (xml instanceof URL) {
                    this.verifier.verify(((URL)xml).toString());
                } else if (xml instanceof InputStream) {
                    this.verifier.verify(new InputSource((InputStream)xml));
                } else if (xml instanceof InputSource) {
                    this.verifier.verify((InputSource)xml);
                } else if (xml instanceof Node) {
                    this.verifier.verify((Node)xml);
                }
            }
            catch (SAXException e) {
                throw new ValidationException(this.saxExceptions.toArray(new SAXParseException[0]));
            }
            catch (IOException e) {
                throw e;
            }
            if (this.saxExceptions.size() > 0) {
                throw new ValidationException(this.saxExceptions.toArray(new SAXParseException[0]));
            }
            return true;
        }
    }
}

