/*
 * Decompiled with CFR 0.152.
 */
package info.bix.tokai.bixpp.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;

final class InputStreamCreator {
    private InputStreamCreator() {
    }

    public static InputStream openStream(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException();
        }
        int timeout = 5000;
        int retry = 5;
        InputStream stream = null;
        try {
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            int i = 0;
            while (i < retry) {
                try {
                    stream = connection.getInputStream();
                    break;
                }
                catch (SocketTimeoutException e) {
                    if (i >= retry - 1) {
                        return null;
                    }
                }
                catch (IOException e) {
                    throw e;
                }
                ++i;
            }
            return stream;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

