/*
 * Decompiled with CFR 0.152.
 */
package info.bix.tokai.bixpp.io;

import com.mindprod.csv.CSVWriter;
import info.bix.tokai.bixpp.binding.BIXpp;
import info.bix.tokai.bixpp.binding.DataItem;
import info.bix.tokai.bixpp.binding.DefinitionItem;
import info.bix.tokai.bixpp.binding.DescriptionItem;
import info.bix.tokai.bixpp.binding.EventItem;
import info.bix.tokai.bixpp.binding.ImageItem;
import info.bix.tokai.bixpp.binding.Item;
import info.bix.tokai.bixpp.binding.RecordingDefinition;
import info.bix.tokai.bixpp.binding.SoundItem;
import info.bix.tokai.bixpp.binding.VectorItem;
import info.bix.tokai.bixpp.utility.BIXppManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.commons.lang.Validate;

public class CSVExporter {
    private static final String SOUND = "Sound";
    private static final String IMAGE = "Image";
    private static final String EVENT = "Event";
    private static final String DESCRIPTION = "Description";
    private static final String EVENT_IDENTIFIER = "*";
    private Charset charset = Charset.defaultCharset();

    public void setCharset(String charset) {
        Validate.notNull((Object)charset);
        this.charset = Charset.forName(charset);
    }

    public String getCharset() {
        return this.charset.displayName();
    }

    public void exportCSV(BIXpp bixpp, File csvFile) throws IOException {
        if (bixpp == null || csvFile == null) {
            throw new IllegalArgumentException();
        }
        RecordingDefinition rd = bixpp.getRecordingDefinition();
        long[] indices = new long[rd.getDefinitionItemCount()];
        int i = 0;
        while (i < indices.length) {
            indices[i] = rd.getDefinitionItem(i).getIndex();
            ++i;
        }
        this.exportCSV(bixpp, csvFile, indices);
    }

    public void exportCSV(BIXpp bixpp, File csvFile, long[] indices) throws IOException {
        if (bixpp == null || csvFile == null || indices == null) {
            throw new IllegalArgumentException();
        }
        CSVWriter writer = null;
        try {
            File tempFile = csvFile.getParentFile();
            if (tempFile != null && !tempFile.exists()) {
                tempFile.mkdirs();
            }
            BIXppManager manager = new BIXppManager(bixpp);
            writer = new CSVWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(csvFile), this.charset)), 1, ',', '\"', true);
            DefinitionItem[] rdItems = this.createDefinitionItemArray(indices, manager);
            this.writeFirstLine(bixpp, writer, rdItems);
            this.writeSecondLine(bixpp, writer, rdItems);
            this.writeThirdLine(bixpp, writer, rdItems);
            this.writeOtherLine(manager, writer, rdItems);
        }
        finally {
            writer.close();
        }
    }

    private DefinitionItem[] createDefinitionItemArray(long[] indices, BIXppManager manager) {
        ArrayList<DefinitionItem> rdItemList = new ArrayList<DefinitionItem>();
        int i = 0;
        while (i < indices.length) {
            DefinitionItem definitionItem = manager.getDefinitionItem(indices[i]);
            if (definitionItem != null && !(definitionItem instanceof VectorItem)) {
                rdItemList.add(definitionItem);
            }
            ++i;
        }
        DefinitionItem[] rdItems = rdItemList.toArray(new DefinitionItem[0]);
        return rdItems;
    }

    private void writeFirstLine(BIXpp bixpp, CSVWriter writer, DefinitionItem[] rdItems) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(bixpp.getStart());
        writer.put("" + calendar.get(1));
        DefinitionItem[] definitionItemArray = rdItems;
        int n = 0;
        int n2 = definitionItemArray.length;
        while (n < n2) {
            DefinitionItem rdItem = definitionItemArray[n];
            writer.put(rdItem.getName() != null ? rdItem.getName() : "");
            ++n;
        }
        writer.nl();
    }

    private void writeSecondLine(BIXpp bixpp, CSVWriter writer, DefinitionItem[] rdItems) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(bixpp.getStart());
        writer.put("" + (calendar.get(2) + 1));
        DefinitionItem[] definitionItemArray = rdItems;
        int n = 0;
        int n2 = definitionItemArray.length;
        while (n < n2) {
            DefinitionItem rdItem = definitionItemArray[n];
            if (rdItem instanceof DataItem) {
                DataItem dataItem = (DataItem)rdItem;
                writer.put(dataItem.getUnit() != null ? dataItem.getUnit() : "");
            } else if (rdItem instanceof EventItem) {
                writer.put(EVENT);
            } else if (rdItem instanceof ImageItem) {
                writer.put(IMAGE);
            } else if (rdItem instanceof SoundItem) {
                writer.put(SOUND);
            } else if (rdItem instanceof DescriptionItem) {
                writer.put(DESCRIPTION);
            }
            ++n;
        }
        writer.nl();
    }

    private void writeThirdLine(BIXpp bixpp, CSVWriter writer, DefinitionItem[] rdItems) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(bixpp.getStart());
        writer.put("" + calendar.get(5));
        DefinitionItem[] definitionItemArray = rdItems;
        int n = 0;
        int n2 = definitionItemArray.length;
        while (n < n2) {
            DefinitionItem rdItem = definitionItemArray[n];
            writer.put(rdItem.getComment() != null ? rdItem.getComment() : "");
            ++n;
        }
        writer.nl();
    }

    private void writeOtherLine(BIXppManager manager, CSVWriter writer, DefinitionItem[] rdItems) {
        Item[][] items = new Item[rdItems.length][];
        int i = 0;
        while (i < items.length) {
            items[i] = manager.getItem(rdItems[i].getIndex());
            ++i;
        }
        int lastDays = (int)manager.getLastDays();
        int i2 = 0;
        while (i2 <= lastDays) {
            writer.put("" + i2);
            int j = 0;
            while (j < rdItems.length) {
                Item item = items[j][i2];
                if (item == null) {
                    writer.put("");
                } else if (rdItems[j] instanceof DataItem) {
                    writer.put(Double.toString(item.getValue()));
                } else if (rdItems[j] instanceof EventItem) {
                    writer.put(EVENT_IDENTIFIER);
                } else if (rdItems[j] instanceof ImageItem) {
                    try {
                        writer.put(item.getImage().getLink().getURIString());
                    }
                    catch (Exception exception) {}
                } else if (rdItems[j] instanceof SoundItem) {
                    try {
                        writer.put(item.getSound().getLink().getURIString());
                    }
                    catch (Exception exception) {}
                } else if (rdItems[j] instanceof DescriptionItem) {
                    writer.put(item.getDescription());
                }
                ++j;
            }
            writer.nl();
            ++i2;
        }
    }
}

